/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import cz.xtf.io.IOUtils;
import cz.xtf.maven.MavenUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.it.VerificationException;

public class Project {
    private static final Path PROJECTS_TMP_DIR = IOUtils.TMP_DIRECTORY.resolve("projects");
    private Path projectDir;
    private Path versionPointer;

    public static Project from(Path projectOrigin, String projectName) throws IOException {
        Path project = Files.createTempDirectory(PROJECTS_TMP_DIR, projectName, new FileAttribute[0]);
        Path pointer = project.resolve(projectName);
        pointer.toFile().mkdir();
        IOUtils.copy(projectOrigin, pointer);
        return new Project(project, pointer);
    }

    private Project(Path path, Path versionPointer) {
        this.projectDir = path;
        this.versionPointer = versionPointer;
    }

    public Project modify(ProjectModifier modifier) throws IOException {
        this.versionPointer = modifier.modify(this.versionPointer);
        return this;
    }

    public Project runMavenBuild(String ... goals) throws VerificationException {
        MavenUtil.forProject(this.versionPointer).forkJvm().executeGoals(goals);
        return this;
    }

    public Project prepareForBinaryBuild() throws IOException {
        Path tmpBin = this.projectDir.resolve("bin");
        tmpBin.toFile().mkdir();
        String[] targetPackages = this.versionPointer.resolve("target").toFile().list(new PackageFileFilter());
        if (targetPackages.length > 0) {
            tmpBin.resolve("deployments").toFile().mkdir();
            for (String deployment : targetPackages) {
                IOUtils.copy(this.versionPointer.resolve("target").resolve(deployment), tmpBin.resolve("deployments").resolve(deployment));
            }
        }
        if (this.versionPointer.resolve("configuration").toFile().exists()) {
            tmpBin.resolve("configuration").toFile().mkdir();
            IOUtils.copy(this.versionPointer.resolve("configuration"), tmpBin.resolve("configuration"));
        }
        this.versionPointer = tmpBin;
        return this;
    }

    public Path getPath() {
        return this.versionPointer;
    }

    static {
        PROJECTS_TMP_DIR.toFile().mkdirs();
    }

    public static class PackageFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String s) {
            return s.matches(".*(\\.war|\\.jar|\\.ear)");
        }
    }

    @FunctionalInterface
    public static interface ProjectModifier {
        public Path modify(Path var1) throws IOException;
    }
}

