/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.jolokia;

import io.fabric8.kubernetes.api.model.Pod;

public class JolokiaRequestBuilder {
    private String masterUrl;
    private String namespace;
    private Pod pod;
    private String beanName;
    private AmqJolokiaRequest amqReq;

    public static JolokiaRequestBuilder newRequest() {
        return new JolokiaRequestBuilder();
    }

    public JolokiaRequestBuilder withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return this;
    }

    public JolokiaRequestBuilder withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public JolokiaRequestBuilder withPod(Pod pod) {
        this.pod = pod;
        return this;
    }

    public AmqJolokiaRequest withAmq() {
        this.beanName = "org.apache.activemq:type=Broker";
        this.amqReq = new AmqJolokiaRequest(this);
        return this.amqReq;
    }

    public JolokiaRequestBuilder endRequest() {
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder(this.masterUrl).append("/api/v1/namespaces/").append(this.namespace).append("/pods").append("/https:").append(this.pod.getMetadata().getName()).append(":8778/proxy").append("/jolokia").append("/exec/").append(this.beanName);
        if (this.amqReq != null) {
            sb.append(",brokerName=").append(this.pod.getMetadata().getName()).append(",destinationType=").append(this.amqReq.destinationType).append(",destinationName=").append(this.amqReq.destinationName).append("/").append(this.amqReq.execMethod).append("%28%29");
        }
        return sb.toString();
    }

    public class AmqJolokiaRequest {
        String destinationName;
        String destinationType;
        String execMethod;
        JolokiaRequestBuilder parent;

        AmqJolokiaRequest(JolokiaRequestBuilder parent) {
            this.parent = parent;
        }

        public AmqJolokiaRequest withQueue(String name) {
            this.destinationType = "Queue";
            this.destinationName = name;
            return this;
        }

        public AmqJolokiaRequest withExecMethod(String execMethod) {
            this.execMethod = execMethod;
            return this;
        }

        public JolokiaRequestBuilder endAmq() {
            return this.parent;
        }
    }
}

