/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.junit.annotation.BypassAuthUser;
import cz.xtf.junit.filter.ExclusionTestClassFilter;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class BypassAuthUserFilter
implements ExclusionTestClassFilter {
    public static final String SYSTEM_PROPERTY_NAME = "org.kie.server.bypass.auth.user";
    private final boolean bypassAuthUser;

    public BypassAuthUserFilter() {
        this.bypassAuthUser = Boolean.valueOf(System.getProperty(SYSTEM_PROPERTY_NAME, "false"));
    }

    @Override
    public boolean exclude(Class<?> testClass) {
        if (Arrays.stream(testClass.getAnnotations()).filter(a -> a instanceof BypassAuthUser).findFirst().isPresent()) {
            return !this.bypassAuthUser;
        }
        return this.bypassAuthUser;
    }

    @ConstructorProperties(value={"bypassAuthUser"})
    public BypassAuthUserFilter(boolean bypassAuthUser) {
        this.bypassAuthUser = bypassAuthUser;
    }

    public String toString() {
        return "BypassAuthUserFilter(bypassAuthUser=" + this.bypassAuthUser + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BypassAuthUserFilter)) {
            return false;
        }
        BypassAuthUserFilter other = (BypassAuthUserFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.bypassAuthUser == other.bypassAuthUser;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BypassAuthUserFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bypassAuthUser ? 79 : 97);
        return result;
    }
}

