/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.pod.ConfigMapVolume;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.builder.pod.EmptyDirVolume;
import cz.xtf.openshift.builder.pod.HostPathVolume;
import cz.xtf.openshift.builder.pod.NFSVolume;
import cz.xtf.openshift.builder.pod.PersistentVolumeClaim;
import cz.xtf.openshift.builder.pod.SecretVolume;
import cz.xtf.openshift.builder.pod.Volume;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PodBuilder
extends AbstractBuilder<Pod, PodBuilder> {
    private final DeploymentConfigBuilder deploymentBuilder;
    private final Set<Volume> volumes = new HashSet<Volume>();
    private final Set<ContainerBuilder> containerBuilders = new HashSet<ContainerBuilder>();
    private final Map<String, String> nodeSelectorLabels = new HashMap<String, String>();
    private int gracefulShutdown = -1;
    private String serviceAccount;
    private Long runAsUser;

    public PodBuilder(String name) {
        this((DeploymentConfigBuilder)null, name);
    }

    PodBuilder(DeploymentConfigBuilder dcBuilder, String name) {
        super(PodBuilder.extractApplicationBuilder(dcBuilder), name);
        this.deploymentBuilder = dcBuilder;
        this.addLabel("name", name);
    }

    public ContainerBuilder container() {
        return this.container(this.getName());
    }

    public Collection<ContainerBuilder> getContainers() {
        return Collections.unmodifiableSet(this.containerBuilders);
    }

    public ContainerBuilder container(String name) {
        return this.getContainerBuilder(name);
    }

    public PodBuilder gracefulShutdown(int seconds) {
        this.gracefulShutdown = seconds;
        return this;
    }

    public PodBuilder addHostPathVolume(String name, String sourceHostDirPath) {
        this.volumes.add(new HostPathVolume(name, sourceHostDirPath));
        return this;
    }

    public PodBuilder addSecretVolume(String name, String secretName) {
        this.volumes.add(new SecretVolume(name, secretName));
        return this;
    }

    public PodBuilder addSecretVolume(String name, String secretName, Map<String, String> items) {
        this.volumes.add(new SecretVolume(name, secretName, items));
        return this;
    }

    public PodBuilder addNFSVolume(String name, String server, String serverPath) {
        this.volumes.add(new NFSVolume(name, server, serverPath));
        return this;
    }

    public PodBuilder addEmptyDirVolume(String name) {
        this.volumes.add(new EmptyDirVolume(name));
        return this;
    }

    public PodBuilder addConfigMapVolume(String name, String configMapName) {
        this.volumes.add(new ConfigMapVolume(name, configMapName));
        return this;
    }

    public PodBuilder addPersistenVolumeClaim(String name, String claimName) {
        this.volumes.add(new PersistentVolumeClaim(name, claimName));
        return this;
    }

    public PodBuilder addServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    public PodBuilder addRunAsUserSecurityContext(Long id) {
        this.runAsUser = id;
        return this;
    }

    public PodBuilder nodeSelector(String key, String value) {
        this.nodeSelectorLabels.put(key, value);
        return this;
    }

    @Override
    public Pod build() {
        PodSpecBuilder specBuilder = new PodSpecBuilder();
        specBuilder.withContainers(this.containerBuilders.stream().map(ContainerBuilder::build).collect(Collectors.toList()));
        specBuilder.withDnsPolicy("ClusterFirst");
        if (!this.nodeSelectorLabels.isEmpty()) {
            specBuilder.withNodeSelector(this.nodeSelectorLabels);
        }
        specBuilder.withRestartPolicy("Always");
        if (StringUtils.isNotBlank((CharSequence)this.serviceAccount)) {
            specBuilder.withServiceAccount(this.serviceAccount);
        }
        if (this.gracefulShutdown >= 0) {
            specBuilder.withTerminationGracePeriodSeconds(Long.valueOf(this.gracefulShutdown));
        }
        specBuilder.withVolumes(this.volumes.stream().map(Volume::build).collect(Collectors.toList()));
        if (this.runAsUser != null) {
            ((PodSpecFluent.SecurityContextNested)specBuilder.withNewSecurityContext().withRunAsUser(this.runAsUser)).endSecurityContext();
        }
        return ((io.fabric8.kubernetes.api.model.PodBuilder)((io.fabric8.kubernetes.api.model.PodBuilder)new io.fabric8.kubernetes.api.model.PodBuilder().withMetadata(this.metadataBuilder().build())).withSpec(specBuilder.build())).build();
    }

    public DeploymentConfigBuilder deployment() {
        if (this.deploymentBuilder == null) {
            throw new IllegalStateException("DeploymentConfigBuilder was not set in constructor");
        }
        return this.deploymentBuilder;
    }

    @Override
    protected PodBuilder getThis() {
        return this;
    }

    private ContainerBuilder getContainerBuilder(String name) {
        ContainerBuilder result;
        Optional<ContainerBuilder> opt = this.containerBuilders.stream().filter(bldr -> bldr.getName().equals(name)).findFirst();
        if (opt.isPresent()) {
            result = opt.get();
        } else {
            result = new ContainerBuilder(this, name);
            this.containerBuilders.add(result);
        }
        return result;
    }

    private static ApplicationBuilder extractApplicationBuilder(DeploymentConfigBuilder dcBuilder) {
        if (dcBuilder == null) {
            return null;
        }
        try {
            return dcBuilder.app();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }
}

