/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.db;

import cz.xtf.docker.DockerContainer;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.EnvironmentConfiguration;
import cz.xtf.openshift.builder.ServiceBuilder;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.builder.pod.PersistentVolumeClaim;
import cz.xtf.openshift.storage.DefaultStatefulAuxiliary;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDatabase
extends DefaultStatefulAuxiliary {
    private final String username;
    private final String password;
    private final String dbName;
    private final String symbolicName;
    private String openShiftName;
    private boolean isObjectStore = false;
    private boolean configureEnvironment = true;
    private String jndiName = null;
    private boolean external = false;
    protected boolean withLivenessProbe;
    protected boolean withReadinessProbe;

    public AbstractDatabase(String symbolicName, String dataDir) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir);
    }

    public AbstractDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        this(symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
        this.configureEnvironment = configureEnvironment;
    }

    public AbstractDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir, pvc);
    }

    public AbstractDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        this("testuser", "testpwd", "testdb", symbolicName, dataDir, pvc);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir) {
        this(username, password, dbName, symbolicName, dataDir, null);
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(symbolicName, dataDir, pvc);
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.symbolicName = symbolicName;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        this(username, password, dbName, symbolicName, dataDir);
        this.withLivenessProbe = withLivenessProbe;
        this.withReadinessProbe = withReadinessProbe;
    }

    public AbstractDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        this(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
        this.configureEnvironment = configureEnvironment;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public abstract String getImageName();

    public abstract int getPort();

    protected void configureContainer(ContainerBuilder containerBuilder) {
    }

    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(this.getSymbolicName() + "_USER", this.getUsername());
        vars.put(this.getSymbolicName() + "_USERNAME", this.getUsername());
        vars.put(this.getSymbolicName() + "_PASSWORD", this.getPassword());
        vars.put(this.getSymbolicName() + "_DATABASE", this.getDbName());
        return vars;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getOpenShiftName() {
        if (this.openShiftName == null) {
            this.openShiftName = this.dbName + "-" + this.getSymbolicName().toLowerCase();
        }
        return this.openShiftName;
    }

    public String getEnvVarPrefix() {
        return this.dbName.toUpperCase() + "_" + this.getSymbolicName().toUpperCase();
    }

    private String getEnvVarName(String paramName) {
        return this.getEnvVarPrefix() + "_" + paramName.toUpperCase();
    }

    @Override
    public Pod getPod() {
        return OpenshiftUtil.getInstance().findNamedPod(this.getOpenShiftName());
    }

    @Override
    public void configureApplicationDeployment(DeploymentConfigBuilder dcBuilder) {
        this.configureEnvironment(dcBuilder.podTemplate().container());
    }

    public void configureService(ApplicationBuilder appBuilder) {
        ServiceBuilder serviceBuilder = (ServiceBuilder)appBuilder.service(this.getOpenShiftName()).setPort(this.getPort()).setContainerPort(this.getPort()).addContainerSelector("name", this.getOpenShiftName()).addLabel("application", appBuilder.getName());
        if (this.external) {
            serviceBuilder.withoutSelectors();
        }
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder) {
        return this.configureDeployment(appBuilder, true);
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder, boolean synchronous) {
        DeploymentConfigBuilder builder = (DeploymentConfigBuilder)appBuilder.deploymentConfig(this.getOpenShiftName(), this.getOpenShiftName(), false).addLabel("application", appBuilder.getName());
        builder.podTemplate().container().fromImage(this.getImageName()).envVars(this.getImageVariables()).port(this.getPort());
        if (synchronous) {
            builder.onConfigurationChange();
            builder.synchronousDeployment();
        }
        this.configureContainer(builder.podTemplate().container());
        if (this.isStateful) {
            this.storagePartition.configureApplicationDeployment(builder);
        }
        if (this.persistentVolClaim != null) {
            builder.podTemplate().addPersistenVolumeClaim(this.persistentVolClaim.getName(), this.persistentVolClaim.getClaimName());
            builder.podTemplate().container().addVolumeMount(this.persistentVolClaim.getName(), this.dataDir, false);
        }
        this.configureService(appBuilder);
        return builder;
    }

    public void configureEnvironment(EnvironmentConfiguration envConfig) {
        String dbServiceMapping = envConfig.getConfigEntries().getOrDefault("DB_SERVICE_PREFIX_MAPPING", "");
        if (dbServiceMapping.length() != 0) {
            dbServiceMapping = dbServiceMapping.concat(",");
        }
        envConfig.configEntry("DB_SERVICE_PREFIX_MAPPING", dbServiceMapping.concat(this.getOpenShiftName() + "=" + this.getEnvVarPrefix())).configEntry(this.getEnvVarName("USERNAME"), this.getUsername()).configEntry(this.getEnvVarName("PASSWORD"), this.getPassword()).configEntry(this.getEnvVarName("DATABASE"), this.getDbName());
        if (this.isObjectStore) {
            envConfig.configEntry("TX_DATABASE_PREFIX_MAPPING", this.getEnvVarPrefix());
        }
        if (this.jndiName != null) {
            envConfig.configEntry(this.getEnvVarName("JNDI"), this.jndiName);
        }
    }

    public AbstractDatabase jndiName(String jndiName) {
        this.jndiName = jndiName;
        return this;
    }

    @Override
    public DockerContainer getContainer() {
        return DockerContainer.createForPod(this.getPod(), this.getOpenShiftName());
    }

    public AbstractDatabase asObjectStore() {
        this.isObjectStore = true;
        return this;
    }

    public AbstractDatabase external() {
        this.external = true;
        return this;
    }

    public AbstractDatabase withProbes() {
        this.withLivenessProbe = true;
        this.withReadinessProbe = true;
        return this;
    }

    public String toString() {
        return "AbstractDatabase{dbName='" + this.dbName + '\'' + '}';
    }
}

