/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.imagestream;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.VersionRegistry;
import java.math.BigDecimal;
import java.util.Optional;

public class ImageRegistry {
    private static final String REGISTRY_HOSTNAME = "registry-docker.";
    private static final String INTERNAL_REGISTRY = "[internal]";
    private static ImageRegistry instance;

    private ImageRegistry() {
    }

    public static ImageRegistry get() {
        if (instance == null) {
            instance = new ImageRegistry();
        }
        return instance;
    }

    public String eap() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap." + VersionRegistry.get().eap().getMajorVersion()));
    }

    public String eapPrevious() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap." + VersionRegistry.get().eap().getMajorVersion() + ".previous"));
    }

    public String tomcat() {
        return this.normalize(TestConfiguration.get().readValue("org.apache.tomcat" + VersionRegistry.get().ews().getMajorVersion()));
    }

    public String eap6() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap.6"));
    }

    public String eap6Previous() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap.6.previous"));
    }

    public String eap7() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap.7"));
    }

    public String eap7Previous() {
        return this.normalize(TestConfiguration.get().readValue("xtf.eap.7.previous"));
    }

    public String jdg() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdg"));
    }

    public String jdgPrevious() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdg.previous"));
    }

    public String jdgClient() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdg.client"));
    }

    public String jdv() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdv"));
    }

    public String jdvClient() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdv.client"));
    }

    public String jdvOdbcTest() {
        return this.normalize(TestConfiguration.get().readValue("xtf.jdv.odbc.test"));
    }

    public String tomcat7() {
        return this.normalize(TestConfiguration.get().readValue("org.apache.tomcat7"));
    }

    public String tomcat8() {
        return this.normalize(TestConfiguration.get().readValue("org.apache.tomcat8"));
    }

    public String amq() {
        return this.normalize(TestConfiguration.get().readValue("xtf.amq"));
    }

    public String postgresql() {
        return this.normalize(TestConfiguration.get().readValue("org.postgresql"));
    }

    public String derby() {
        return this.normalize(TestConfiguration.get().readValue("org.apache.derby"));
    }

    public String mysql() {
        return this.normalize(TestConfiguration.get().readValue("com.mysql"));
    }

    public String mongodb() {
        return this.normalize(TestConfiguration.get().readValue("com.mongodb"));
    }

    public String nfs() {
        return this.normalize(TestConfiguration.get().readValue("org.nfs"));
    }

    public String fuseJavaMain() {
        return this.normalize(TestConfiguration.get().readValue("org.fuse.java_main"));
    }

    public String fuseKaraf() {
        return this.normalize(TestConfiguration.get().readValue("org.fuse.karaf"));
    }

    public String brms() {
        return this.normalize(TestConfiguration.get().readValue("xtf.brms"));
    }

    public String bpms() {
        return this.normalize(TestConfiguration.get().readValue("xtf.bpms"));
    }

    public String bpmsPrevious() {
        return this.normalize(TestConfiguration.get().readValue("xtf.bpms.previous"));
    }

    public String bpmsLdapTest() {
        return this.normalize(TestConfiguration.get().readValue("xtf.bpms.ldap.test"));
    }

    public String sso() {
        return this.normalize(TestConfiguration.get().readValue("xtf.sso"));
    }

    public String ssoPrevious() {
        return this.normalize(TestConfiguration.get().readValue("xtf.sso.previous"));
    }

    public String phantomJs() {
        return this.normalize(TestConfiguration.get().readValue("xtf.phantomjs"));
    }

    public String h2() {
        return this.normalize(TestConfiguration.get().readValue("xtf.h2"));
    }

    public String msa() {
        return this.normalize(TestConfiguration.get().readValue("xtf.msa"));
    }

    public String zipkin() {
        return this.normalize(TestConfiguration.get().readValue("io.zipkin.java"));
    }

    public String rad() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.spark"));
    }

    public String oshinkoRest() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.oshinko.rest"));
    }

    public String oshinkoWeb() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.oshinko.webui"));
    }

    public String oshinkoCli() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.oshinko.cli"));
    }

    public String pySpark() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.driver.python"));
    }

    public String javaSpark() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.driver.java"));
    }

    public String scalaSpark() {
        return this.normalize(TestConfiguration.get().readValue("xtf.rad.driver.scala"));
    }

    public String squid() {
        return this.normalize(TestConfiguration.get().readValue("org.squid-cache"));
    }

    public String tcpProxy() {
        return this.normalize(TestConfiguration.get().readValue("xtf.tcp-proxy"));
    }

    public String midlewareManagerService() {
        return this.normalize(TestConfiguration.get().readValue("org.hawkular.service"));
    }

    public String midlewareManagerStorage() {
        return this.normalize(TestConfiguration.get().readValue("org.hawkular.datastore"));
    }

    private String normalize(String image) {
        if (image != null && image.startsWith(INTERNAL_REGISTRY)) {
            return image.replace(INTERNAL_REGISTRY, REGISTRY_HOSTNAME + TestConfiguration.routeDomain() + ":80");
        }
        return image;
    }

    public static Image toImage(String image) {
        return new Image(image);
    }

    public static boolean isVersionAtLeast(BigDecimal version, String image) {
        String imageTag = new Image(image).getImageTag();
        String[] split = imageTag.split("-");
        try {
            return new BigDecimal(split[0]).compareTo(version) >= 0;
        }
        catch (NumberFormatException x) {
            return true;
        }
    }

    public static Optional<String> imageStreamVersion(String image) {
        String imageTag = new Image(image).getImageTag();
        String[] split = imageTag.split("-");
        if (split.length == 2) {
            return Optional.of(split[0]);
        }
        if (split.length == 1 && imageTag.matches("\\d+\\.\\d+")) {
            return Optional.of(imageTag);
        }
        return Optional.empty();
    }

    public static class Image {
        private String imageName;
        private String imageTag;

        public Image(String image) {
            String[] tokens = image.split(":");
            switch (tokens.length) {
                case 1: {
                    this.imageName = tokens[0];
                    this.imageTag = "";
                    break;
                }
                case 2: {
                    this.imageName = tokens[0];
                    this.imageTag = tokens[1];
                    break;
                }
                case 3: {
                    this.imageName = tokens[0] + ":" + tokens[1];
                    this.imageTag = tokens[2];
                }
            }
        }

        public String getImageName() {
            return this.imageName;
        }

        public String getImageTag() {
            return this.imageTag;
        }

        public String toString() {
            return "Image{imageName='" + this.imageName + '\'' + ", imageTag='" + this.imageTag + '\'' + '}';
        }
    }
}

