/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.messaging;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.ActiveMQTransport;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.PVCBuilder;
import cz.xtf.openshift.builder.PodBuilder;
import cz.xtf.openshift.builder.PortBuilder;
import cz.xtf.openshift.builder.RouteBuilder;
import cz.xtf.openshift.builder.ServiceBuilder;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.imagestream.ImageRegistry;
import cz.xtf.wait.WaitUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;

public class AmqStandaloneBuilder {
    private static final String AMQ_IMAGE = ImageRegistry.get().amq();
    private ApplicationBuilder appBuilder;
    private String appName;
    private String podName;
    private Set<ActiveMQTransport> transports;
    private List<Consumer<ContainerBuilder>> containerBuilderFuncs;
    private int replicas = 1;
    private String suffix = "";
    private boolean enableNodePort = false;
    private boolean enableDrainer = false;
    private String claimName;

    public AmqStandaloneBuilder(String appName) {
        this(appName, null);
    }

    public AmqStandaloneBuilder(String appName, String podName) {
        this.podName = podName;
        this.appName = appName;
        if (StringUtils.isBlank((CharSequence)podName)) {
            this.podName = appName + "-pod";
        }
        this.appBuilder = new ApplicationBuilder(this.appName);
        this.appBuilder.deploymentConfig(this.appName, this.podName, false).onConfigurationChange().podTemplate().container(this.appName).fromImage(AMQ_IMAGE);
        this.transports = new HashSet<ActiveMQTransport>();
        this.containerBuilderFuncs = new LinkedList<Consumer<ContainerBuilder>>();
    }

    public AmqStandaloneBuilder transport(ActiveMQTransport ... transports) {
        Arrays.asList(transports).stream().forEach(this.transports::add);
        return this;
    }

    public AmqStandaloneBuilder container(Consumer<ContainerBuilder> func) {
        this.containerBuilderFuncs.add(func);
        return this;
    }

    public AmqStandaloneBuilder nfs(String volumeName, String nfsServer, String serverPath, String mountPath, boolean readOnly) {
        this.container(cb -> cb.addVolumeMount(volumeName, mountPath, readOnly).pod().addNFSVolume(volumeName, nfsServer, serverPath));
        return this;
    }

    public AmqStandaloneBuilder nfs(String volumeName, String serverPath, String mountPath, boolean readOnly) {
        this.nfs(volumeName, TestConfiguration.nfsServer(), serverPath, mountPath, readOnly);
        return this;
    }

    public AmqStandaloneBuilder pvc(String volumeName, String claimName, String mountPath, boolean readOnly) {
        this.container(cb -> cb.addVolumeMount(volumeName, mountPath, readOnly).pod().addPersistenVolumeClaim(volumeName, claimName));
        return this;
    }

    public AmqStandaloneBuilder withDefaultPVC() {
        String claimName;
        this.claimName = claimName = "amq-claim-" + Integer.toString(Math.abs(new Random().nextInt()), 36);
        OpenshiftUtil.getInstance().createPersistentVolumeClaim(new PVCBuilder(claimName).accessRWX().storageSize("1Gi").build());
        this.pvc("store", claimName, "/opt/amq/data", false);
        return this;
    }

    public AmqStandaloneBuilder withDefaultMeshConf() {
        this.container(cb -> {
            PodBuilder cfr_ignored_0 = (PodBuilder)cb.envVar("AMQ_MESH_SERVICE_NAME", "amq-mesh").envVar("AMQ_MESH_DISCOVERY_TYPE", "kube").envVar("AMQ_MESH_SERVICE_NAMESPACE", OpenshiftUtil.getInstance().getContext().getNamespace()).pod().addLabel("topology", "mesh");
        });
        return this;
    }

    public AmqStandaloneBuilder withResourcesSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public AmqStandaloneBuilder withReplicas(int replicas) {
        this.replicas = replicas;
        this.appBuilder.deploymentConfig(this.appName).setReplicas(this.replicas);
        return this;
    }

    public AmqStandaloneBuilder withNodePort() {
        this.enableNodePort = true;
        return this;
    }

    public AmqStandaloneBuilder withDrainerPod() {
        this.enableDrainer = true;
        return this;
    }

    public AmqStandaloneBuilder deploy() {
        if (this.transports.isEmpty()) {
            this.transport(ActiveMQTransport.OPENWIRE, ActiveMQTransport.AMQP, ActiveMQTransport.MQTT, ActiveMQTransport.STOMP);
        }
        ServiceBuilder service = this.appBuilder.service("amq-service" + this.suffix).addContainerSelector("name", this.podName);
        this.transports.stream().forEach(t -> service.ports(new PortBuilder(t.toString()).port(t.getPort()).targetPort(t.getPort()).build()));
        ServiceBuilder secureService = this.appBuilder.service("amq-sec-service" + this.suffix).addContainerSelector("name", this.podName);
        this.transports.stream().forEach(t -> secureService.ports(new PortBuilder((Object)t + "-ssl").port(t.getSslPort()).targetPort(t.getSslPort()).build()));
        this.transports.stream().forEach(t -> this.appBuilder.route((Object)t + "-sec-route" + this.suffix).passthrough().forService("amq-sec-service" + this.suffix).targetPort(t.getSslPort()).exposedAsHost(RouteBuilder.createHostName("amq-" + (Object)t + this.suffix)));
        if (this.enableNodePort) {
            service.nodePort();
            secureService.nodePort();
        }
        this.container(cb -> cb.envVar("AMQ_KEYSTORE_TRUSTSTORE_DIR", "/opt/amq/conf").envVar("AMQ_KEYSTORE", "broker.ks").envVar("AMQ_TRUSTSTORE", "broker.ts").envVar("AMQ_KEYSTORE_PASSWORD", "password").envVar("AMQ_TRUSTSTORE_PASSWORD", "password").port(8778, "jolokia").addReadinessProbe().createExecProbe("/bin/bash", "-c", "/opt/amq/bin/readinessProbe.sh"));
        for (Consumer<ContainerBuilder> cbf : this.containerBuilderFuncs) {
            cbf.accept(this.appBuilder.deploymentConfig(this.appName).podTemplate().container(this.appName));
        }
        this.appBuilder.buildApplication().deployWithoutBuild();
        if (this.enableDrainer) {
            String drainerName = this.appName + "-drainer";
            ApplicationBuilder drainerBuilder = new ApplicationBuilder(drainerName);
            drainerBuilder.deploymentConfig(drainerName, drainerName, false).onConfigurationChange().podTemplate().container(drainerName).addCommand("/opt/amq/bin/drain.sh").fromImage(AMQ_IMAGE);
            drainerBuilder.deploymentConfig(drainerName).podTemplate().container(drainerName).envVar("AMQ_MESH_SERVICE_NAME", "amq-mesh").envVar("AMQ_MESH_DISCOVERY_TYPE", "kube").envVar("AMQ_MESH_SERVICE_NAMESPACE", OpenshiftUtil.getInstance().getContext().getNamespace());
            drainerBuilder.deploymentConfig(drainerName).podTemplate().container(drainerName).addVolumeMount("store", "/opt/amq/data", false).pod().addPersistenVolumeClaim("store", this.claimName);
            drainerBuilder.buildApplication().deployWithoutBuild();
        }
        try {
            if (!WaitUtil.waitFor(WaitUtil.areNPodsReady(this.podName, this.replicas), WaitUtil.hasPodRestarted(this.podName), 1000L, 300000L)) {
                Assertions.fail((String)("Pod " + this.podName + " has restarted, presumably failing."));
            }
        }
        catch (InterruptedException x) {
            throw new RuntimeException("Interrupted during wait for deployment");
        }
        catch (TimeoutException x) {
            throw new RuntimeException("Timeout waiting for " + this.podName + " application deployment");
        }
        return this;
    }

    public AmqStandaloneBuilder service(String name, int port, String selector) {
        this.appBuilder.service(name).ports(new PortBuilder(name).port(port).targetPort(port).build()).addContainerSelector("name", selector);
        return this;
    }
}

