/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.storage;

import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.PVCBuilder;

public class StoragePartition {
    private final String mountPoint;
    private final int claimNumber;

    public StoragePartition(int claimNumber, String mountPoint) {
        this.mountPoint = mountPoint;
        this.claimNumber = claimNumber;
    }

    public void configureApplicationDeployment(DeploymentConfigBuilder builder) {
        String volumeName = builder.app().getName() + "-" + this.claimNumber;
        OpenshiftUtil openshift = OpenshiftUtil.getInstance();
        PVCBuilder pvc = new PVCBuilder(volumeName).accessRWX().storageSize("512m");
        openshift.createPersistentVolumeClaim(pvc.build());
        builder.podTemplate().addPersistenVolumeClaim(volumeName, volumeName);
        builder.podTemplate().container().addVolumeMount(volumeName, this.mountPoint, false);
    }
}

