/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.webdriver;

import cz.xtf.webdriver.GhostDriverService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Consumer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverService {
    private static WebDriverService webDriverService;
    private ThreadLocal<WebDriver> webDriver = new ThreadLocal();

    private WebDriverService() {
    }

    private WebDriver createWebDriver(Consumer<DesiredCapabilities> desiredCapabilities) {
        String hostName = GhostDriverService.get().getHostName();
        DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
        if (desiredCapabilities != null) {
            desiredCapabilities.accept(capabilities);
        }
        try {
            RemoteWebDriver driver = new RemoteWebDriver(new URL("http://localhost:" + GhostDriverService.get().getLocalPort() + "/"), (Capabilities)capabilities);
            driver.manage().window().setSize(new Dimension(1920, 1080));
            return driver;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Wrong hostName '" + hostName + "', possibly GhostDriverService::start not called ", e);
        }
    }

    public WebDriver getWebDriver() {
        return this.webDriver.get();
    }

    public static synchronized WebDriverService get() {
        if (webDriverService == null) {
            webDriverService = new WebDriverService();
        }
        return webDriverService;
    }

    public WebDriver start(Consumer<DesiredCapabilities> desiredCapabilities) {
        WebDriver driver = this.createWebDriver(desiredCapabilities);
        this.webDriver.set(driver);
        return driver;
    }

    public WebDriver start() {
        return this.start(null);
    }

    public void stop() {
        this.webDriver.get().close();
        this.webDriver.set(null);
    }
}

