/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf;

import cz.xtf.TestConfiguration;
import cz.xtf.git.GitLabUtil;
import cz.xtf.http.HttpClient;
import cz.xtf.junit.annotation.release.SinceVersion;
import cz.xtf.junit.annotation.release.SkipFor;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.PodService;
import cz.xtf.openshift.imagestream.ImageRegistry;
import cz.xtf.time.TimeUtil;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.ContentType;
import org.assertj.core.api.JUnitSoftAssertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestParent {
    private static final Logger log = LoggerFactory.getLogger(TestParent.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TestParent.class);
    private static String currentTestClass = null;
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestWatcher testWatcher = new LoggingTestWatcher();
    @Rule
    public final JUnitSoftAssertions softly = new JUnitSoftAssertions();
    private static GitLabUtil GITLAB;

    @Before
    public void setCurrentTestClass() {
        currentTestClass = this.getClass().getName();
    }

    public static String getCurrentTestClass() {
        return currentTestClass == null ? "UNSET" : currentTestClass;
    }

    private String getRegistryOrInstanceImage(String image) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (image.startsWith("$")) {
            return (String)this.getClass().getMethod(image.replace("$", ""), new Class[0]).invoke((Object)this, new Object[0]);
        }
        return (String)ImageRegistry.class.getDeclaredMethod(image, new Class[0]).invoke((Object)ImageRegistry.get(), new Object[0]);
    }

    @Before
    public void skipIfSinceVersionAnnotation() {
        for (Method method : this.getClass().getMethods()) {
            SkipFor[] skipFors;
            SinceVersion[] sinceVersions;
            if (!method.getName().equals(this.name.getMethodName())) continue;
            for (SinceVersion sinceVersion : sinceVersions = (SinceVersion[])method.getAnnotationsByType(SinceVersion.class)) {
                try {
                    String sinceVersionVersion;
                    String image = this.getRegistryOrInstanceImage(sinceVersion.image());
                    if (!image.contains(sinceVersion.name()) || ImageRegistry.isVersionAtLeast(new BigDecimal(sinceVersionVersion = sinceVersion.since().split("-")[0]), image)) continue;
                    if (!sinceVersion.jira().isEmpty()) {
                        Assume.assumeTrue((String)(sinceVersion.jira() + ", Image " + image + " (" + sinceVersion.image() + ") stream containing " + sinceVersion.name() + " must be of version at least " + sinceVersionVersion), (boolean)false);
                        continue;
                    }
                    Assume.assumeTrue((String)("Image " + image + " (" + sinceVersion.image() + ") stream containing " + sinceVersion.name() + " must be of version at least " + sinceVersionVersion), (boolean)false);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("Error invoking during @SinceVersion processing", (Throwable)e);
                }
            }
            for (SkipFor skipFor : skipFors = (SkipFor[])method.getAnnotationsByType(SkipFor.class)) {
                try {
                    String image = this.getRegistryOrInstanceImage(skipFor.image());
                    if (!image.contains(skipFor.name())) continue;
                    if (!skipFor.reason().isEmpty()) {
                        Assume.assumeTrue((String)("Skipping: " + skipFor.reason() + " - image " + image + " (" + skipFor.image() + ") stream containing " + skipFor.name()), (boolean)false);
                        continue;
                    }
                    Assume.assumeTrue((String)("Skipping - image " + image + " (" + skipFor.image() + ") stream containing " + skipFor.name()), (boolean)false);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("Error invoking during @SkipFor processing", (Throwable)e);
                }
            }
        }
    }

    @AfterClass
    public static void cleanupNamespace() {
        OpenshiftUtil.getInstance().cleanProject(true);
    }

    @After
    public void gatherJacocoExecsFromPods() {
        if (TestConfiguration.jacoco()) {
            OpenshiftUtil openshift = OpenshiftUtil.getInstance();
            openshift.withDefaultUser(c -> ((PodList)((FilterWatchListDeletable)c.pods().withLabel("jacoco")).list()).getItems()).stream().forEach(pod -> {
                String jolokiaGetSessionUrl = String.format("%s/api/v1/namespaces/%s/pods/https:%s:8778/proxy/jolokia/read/org.jacoco:type=Runtime/SessionId", TestConfiguration.masterUrl(), openshift.getContext().getNamespace(), pod.getMetadata().getName());
                String jolokiaPostUrl = String.format("%s/api/v1/namespaces/%s/pods/https:%s:8778/proxy/jolokia/", TestConfiguration.masterUrl(), openshift.getContext().getNamespace(), pod.getMetadata().getName());
                try {
                    String sessionId = HttpClient.get(jolokiaGetSessionUrl).bearerAuth(openshift.getContext().getToken()).response();
                    int responseCode = HttpClient.post(jolokiaPostUrl).data("{\"type\":\"exec\",\"mbean\":\"org.jacoco:type=Runtime\",\"operation\":\"dump(boolean)\",\"arguments\":[false]}", ContentType.APPLICATION_JSON).bearerAuth(openshift.getContext().getToken()).code();
                    if (responseCode == 200) {
                        PodService ps = new PodService((Pod)pod);
                        Path testPodDir = Paths.get("tmp", "jacoco", TestParent.getCurrentTestClass(), pod.getMetadata().getName());
                        testPodDir.toFile().mkdirs();
                        ps.execAndConsume(istream -> FileUtils.copyInputStreamToFile((InputStream)istream, (File)testPodDir.resolve(this.name.getMethodName() + ".jacoco.exec").toFile()), "cat", "/tmp/jacoco.exec");
                    } else {
                        log.error("Error calling jacoco dump on {}", (Object)pod.getMetadata().getName());
                    }
                }
                catch (IOException e) {
                    log.error("Cannot connect to jolokia on pod " + pod.getMetadata().getName() + " during " + this.name, (Throwable)e);
                }
            });
        }
    }

    public static Path findApplicationDirectory(String moduleName, String appName, String subModuleName) {
        Path path = FileSystems.getDefault().getPath("src/test/resources/apps", appName);
        if (Files.exists(path, new LinkOption[0]) && path.toAbsolutePath().toString().contains(moduleName)) {
            return path;
        }
        LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        if (subModuleName != null) {
            path = FileSystems.getDefault().getPath("src/test/resources/apps/" + subModuleName, appName);
            if (Files.exists(path, new LinkOption[0]) && path.toAbsolutePath().toString().contains(moduleName)) {
                return path;
            }
            LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        }
        if (Files.exists(path = FileSystems.getDefault().getPath(moduleName + "/src/test/resources/apps", appName), new LinkOption[0])) {
            return path;
        }
        LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        if (subModuleName != null) {
            path = FileSystems.getDefault().getPath(moduleName + "/src/test/resources/apps/" + subModuleName, appName);
            if (Files.exists(path, new LinkOption[0]) && path.toAbsolutePath().toString().contains(moduleName)) {
                return path;
            }
            LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        }
        if (Files.exists(path = FileSystems.getDefault().getPath("../" + moduleName + "/src/main/resources/apps", appName), new LinkOption[0])) {
            return path;
        }
        LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        path = FileSystems.getDefault().getPath("../" + moduleName + "/src/test/resources/apps", appName);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        LOGGER.info("Path {} does not exist", (Object)path.toAbsolutePath());
        throw new IllegalArgumentException("Cannot find directory with STI app sources");
    }

    public static Path findApplicationDirectory(String moduleName, String appName) {
        return TestParent.findApplicationDirectory(moduleName, appName, null);
    }

    public static Path findModuleDirectory(String moduleName) {
        Path path = FileSystems.getDefault().getPath("..", moduleName);
        return path;
    }

    @AfterClass
    public static void alert() {
        if (TestConfiguration.testAlert()) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Test completed");
        }
    }

    public static synchronized GitLabUtil gitlab() {
        if (GITLAB == null) {
            GITLAB = new GitLabUtil();
        }
        return GITLAB;
    }

    private static final class LoggingTestWatcher
    extends TestWatcher {
        private Map<String, Long> times = new HashMap<String, Long>();

        private LoggingTestWatcher() {
        }

        protected void starting(Description description) {
            LOGGER.info(" *** Test {} is starting *** ", (Object)this.getTestId(description));
            this.times.put(this.getTestId(description), System.currentTimeMillis());
        }

        protected void succeeded(Description description) {
            long testTime = System.currentTimeMillis() - this.times.get(this.getTestId(description));
            LOGGER.info(" *** Test {} succeeded after {} *** ", (Object)this.getTestId(description), (Object)TimeUtil.millisToString(testTime));
        }

        protected void failed(Throwable e, Description description) {
            long testTime = System.currentTimeMillis() - this.times.get(this.getTestId(description));
            LOGGER.warn(" *** Test {} failed after {} *** ", (Object)this.getTestId(description), (Object)TimeUtil.millisToString(testTime));
        }

        protected void skipped(AssumptionViolatedException e, Description description) {
            long testTime = System.currentTimeMillis() - this.times.get(this.getTestId(description));
            LOGGER.warn(" *** Test {} skipped after {} *** ", (Object)this.getTestId(description), (Object)TimeUtil.millisToString(testTime));
        }

        private String getTestId(Description description) {
            return description.getClassName() + "." + description.getMethodName();
        }
    }
}

