/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import cz.xtf.TestConfiguration;
import cz.xtf.TestParent;
import cz.xtf.build.BuildProcess;
import cz.xtf.build.PathBuildDefinition;
import cz.xtf.build.PathBuildProcess;
import cz.xtf.build.SourceCodeUpdater;
import cz.xtf.git.GitProject;
import cz.xtf.git.GitUtil;
import cz.xtf.git.PomModifier;
import cz.xtf.io.IOUtils;
import cz.xtf.tuple.Tuple;
import io.fabric8.openshift.api.model.BuildConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathGitBuildProcess
extends PathBuildProcess {
    private static final Logger log = LoggerFactory.getLogger(PathGitBuildProcess.class);
    private boolean initialized = false;
    private GitProject git = null;

    public PathGitBuildProcess(PathBuildDefinition definition) {
        super(definition);
    }

    @Override
    public void deployBuild() {
        String gitRepo = TestParent.gitlab().createProjectFromPath(this.buildName, this.pathToProject).getHttpUrl();
        this.deployBuildFromGit(gitRepo);
    }

    @Override
    public void deleteBuild() {
        if (this.isBuildConfigPresent() && GitUtil.checkIfRepositoryExist(this.getGitUri(this.getBuildConfig()))) {
            TestParent.gitlab().deleteProject(this.buildName);
        }
        this.deleteOpenshiftResources();
    }

    @Override
    public void updateBuild() {
        this.git.addAll();
        this.git.commit("Autocommit by build manager");
        this.git.push();
        this.startBuild(this.getBuildConfig());
    }

    @Override
    public BuildProcess.BuildStatus getBuildStatus() {
        BuildConfig bc = this.getBuildConfig();
        BuildProcess.BuildStatus status = this.getCommonStatus(bc);
        boolean buildPresent = status == BuildProcess.BuildStatus.RUNNING || status == BuildProcess.BuildStatus.READY || status == BuildProcess.BuildStatus.DEPLOYED || status == BuildProcess.BuildStatus.PENDING;
        boolean checkCodeForEquality = !this.initialized;
        this.initialized = true;
        if (checkCodeForEquality && buildPresent) {
            String gitUri = this.getGitUri(bc);
            if (GitUtil.checkIfRepositoryExist(gitUri)) {
                Tuple.Pair<Path, Path> projects;
                try {
                    projects = this.prepareProjects(gitUri);
                }
                catch (IOException e) {
                    log.error("Hit IO Exception", (Throwable)e);
                    return BuildProcess.BuildStatus.ERROR;
                }
                BuildProcess.BuildStatus sourceStatus = this.areProjectsDifferent(projects.getFirst(), projects.getSecond());
                if (sourceStatus != BuildProcess.BuildStatus.READY) {
                    return sourceStatus;
                }
            } else {
                return BuildProcess.BuildStatus.GIT_REPO_GONE;
            }
        }
        return status;
    }

    private String getGitUri(BuildConfig bc) {
        return bc.getSpec().getSource().getGit().getUri();
    }

    private Tuple.Pair<Path, Path> prepareProjects(String gitUri) throws IOException {
        Path bmTmpBuildDir = IOUtils.TMP_DIRECTORY.resolve("bm").resolve(this.buildName);
        Path expectedSourcePath = bmTmpBuildDir.resolve("expected-source");
        Path presentSourcePath = bmTmpBuildDir.resolve("present-source");
        expectedSourcePath.toFile().mkdirs();
        presentSourcePath.toFile().mkdirs();
        this.git = GitUtil.cloneRepository(presentSourcePath, gitUri, TestConfiguration.gitLabUsername(), TestConfiguration.gitLabPassword());
        PomModifier pom = new PomModifier(this.pathToProject.toAbsolutePath(), expectedSourcePath);
        expectedSourcePath.toFile().mkdir();
        IOUtils.copy(this.pathToProject, expectedSourcePath);
        pom.modify();
        return Tuple.pair(expectedSourcePath, presentSourcePath);
    }

    private BuildProcess.BuildStatus areProjectsDifferent(Path expected, Path present) {
        try {
            log.info("Checking diff between source codes: expected -> present");
            SourceCodeUpdater expectedPresentComparator = new SourceCodeUpdater(expected, present, SourceCodeUpdater.OnDiff.COPY);
            Files.walkFileTree(expected, expectedPresentComparator);
            log.info("Checking diff between source codes: present -> expected");
            SourceCodeUpdater presentExpectedComparator = new SourceCodeUpdater(present, expected, SourceCodeUpdater.OnDiff.DELETE);
            Files.walkFileTree(present, presentExpectedComparator);
            if (expectedPresentComparator.isError() || presentExpectedComparator.isError()) {
                return BuildProcess.BuildStatus.ERROR;
            }
            if (expectedPresentComparator.isDiffPresent() || presentExpectedComparator.isDiffPresent()) {
                return BuildProcess.BuildStatus.SOURCE_CHANGE;
            }
            return BuildProcess.BuildStatus.READY;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            log.info("IO happend, new build will be created");
            return BuildProcess.BuildStatus.ERROR;
        }
    }
}

