/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.git;

import cz.xtf.git.GitProject;
import cz.xtf.io.IOUtils;
import cz.xtf.ssh.SshUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitUtil.class);
    public static final Path REPOSITORIES = IOUtils.TMP_DIRECTORY.resolve("git");

    private GitUtil() {
    }

    public static GitProject cloneRepository(Path target, String url) {
        return GitUtil.cloneRepository(target, url, null, null, "master");
    }

    public static GitProject cloneRepository(Path target, String url, String branch) {
        return GitUtil.cloneRepository(target, url, null, null, branch);
    }

    public static GitProject cloneRepository(Path target, String url, String username, String password) {
        return GitUtil.cloneRepository(target, url, username, password, "master");
    }

    public static GitProject cloneRepository(Path target, String url, String username, String password, String branch) {
        SshSessionFactory.setInstance((SshSessionFactory)SshUtil.getInstance().initSshSessionFactory());
        if (Files.exists(target, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)target.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Unable to delete directory", (Throwable)e);
            }
        }
        CloneCommand cloneCommand = Git.cloneRepository().setBranch(branch).setURI(url).setDirectory(target.toFile());
        UsernamePasswordCredentialsProvider credentials = null;
        if (username != null && password != null) {
            credentials = new UsernamePasswordCredentialsProvider(username, password);
            cloneCommand = (CloneCommand)cloneCommand.setCredentialsProvider((CredentialsProvider)credentials);
        }
        try {
            Git git = cloneCommand.call();
            if (StringUtils.isNotBlank((CharSequence)branch)) {
                git.checkout().setName(branch).call();
            }
            return new GitProject(target, git, (CredentialsProvider)credentials);
        }
        catch (GitAPIException ex) {
            throw new RuntimeException("Unable to clone git repository", ex);
        }
    }

    public static GitProject initRepository(Path target) {
        return GitUtil.initRepository(target, null, null, null);
    }

    public static GitProject initRepository(Path target, String url) {
        return GitUtil.initRepository(target, url, null, null);
    }

    public static GitProject initRepository(Path target, String url, String username, String password) {
        SshSessionFactory.setInstance((SshSessionFactory)SshUtil.getInstance().initSshSessionFactory());
        InitCommand initCommand = Git.init().setDirectory(target.toFile());
        UsernamePasswordCredentialsProvider credentials = null;
        if (username != null && password != null) {
            credentials = new UsernamePasswordCredentialsProvider(username, password);
        }
        try {
            Git repo = initCommand.call();
            GitProject project = new GitProject(target, repo, (CredentialsProvider)credentials);
            project.setUrl(url);
            return project;
        }
        catch (GitAPIException ex) {
            throw new RuntimeException("Unable to init git repository", ex);
        }
    }

    public static boolean checkIfRepositoryExist(String url) {
        try {
            Git.lsRemoteRepository().setRemote(url).call();
        }
        catch (GitAPIException e) {
            LOGGER.debug("Repository \"" + url + "\" does not exist.");
            return false;
        }
        return true;
    }
}

