/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit;

import com.google.common.base.Predicate;
import cz.xtf.junit.annotation.ImageStream;
import cz.xtf.junit.annotation.ImageStreams;
import cz.xtf.openshift.imagestream.ImageStreamAnnotationConverter;
import cz.xtf.openshift.imagestream.ImageStreamRequest;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

final class SuiteUtils {
    private SuiteUtils() {
    }

    public static Set<ImageStreamRequest> getImageStreamRequests(Class<?> suiteClass, List<Class<?>> testClasses) {
        HashSet<ImageStreamRequest> requests = new HashSet<ImageStreamRequest>();
        requests.addAll(SuiteUtils.getImageStreamRequestsForClass(suiteClass));
        testClasses.forEach(c -> requests.addAll(SuiteUtils.getImageStreamRequestsForClass(c)));
        return requests;
    }

    private static List<ImageStreamRequest> getImageStreamRequestsForClass(Class<?> c) {
        ArrayList<ImageStreamRequest> requests = new ArrayList<ImageStreamRequest>();
        SuiteUtils.addIfApplicable(c, ReflectionUtils.getAllAnnotations(c, (Predicate[])new Predicate[]{SuiteUtils.isImageStreams()}).stream().map(a -> (ImageStreams)a).flatMap(iss -> Stream.of(iss.value())), requests);
        SuiteUtils.addIfApplicable(c, ReflectionUtils.getAllAnnotations(c, (Predicate[])new Predicate[]{SuiteUtils.isImageStream()}).stream().map(a -> (ImageStream)a), requests);
        return requests;
    }

    private static Predicate<Annotation> isImageStreams() {
        return a -> a.annotationType() == ImageStreams.class;
    }

    private static Predicate<Annotation> isImageStream() {
        return a -> a.annotationType() == ImageStream.class;
    }

    private static void addIfApplicable(Class<?> c, Stream<ImageStream> stream, List<ImageStreamRequest> requests) {
        stream.flatMap(is -> SuiteUtils.isApplicable(c, is) ? Stream.of(is) : Stream.of(new ImageStream[0])).map(is -> ImageStreamAnnotationConverter.convert(is)).forEach(r -> requests.add((ImageStreamRequest)r));
    }

    private static boolean isApplicable(Class<?> c, ImageStream is) {
        if (StringUtils.isNotBlank((CharSequence)is.condition())) {
            try {
                return (Boolean)c.getMethod(is.condition(), new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(String.format("Cannot invoke conditional method '%s' in class '%s'", is.condition(), c), e);
            }
        }
        return true;
    }
}

