/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.junit.filter.ExclusionTestClassFilter;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AnnotationNameFilter
implements ExclusionTestClassFilter {
    public static final String SYSTEM_PROPERTY_NAME = "test.filter.annotation";
    private final List<String> annotationNames;

    public AnnotationNameFilter() {
        String annotationNames = System.getProperty(SYSTEM_PROPERTY_NAME);
        this.annotationNames = StringUtils.isNotBlank((CharSequence)annotationNames) ? Arrays.asList(annotationNames.split(",")) : null;
    }

    public AnnotationNameFilter(String annotationName) {
        this.annotationNames = Collections.singletonList(annotationName);
    }

    @Override
    public boolean exclude(Class<?> testClass) {
        if (this.annotationNames == null) {
            return false;
        }
        for (String annotationName : this.annotationNames) {
            if (!Arrays.stream(testClass.getAnnotations()).anyMatch(a -> a.annotationType().getSimpleName().equals(annotationName))) continue;
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"annotationNames"})
    public AnnotationNameFilter(List<String> annotationNames) {
        this.annotationNames = annotationNames;
    }

    public String toString() {
        return "AnnotationNameFilter(annotationNames=" + this.getAnnotationNames() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationNameFilter)) {
            return false;
        }
        AnnotationNameFilter other = (AnnotationNameFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$annotationNames = this.getAnnotationNames();
        List<String> other$annotationNames = other.getAnnotationNames();
        return !(this$annotationNames == null ? other$annotationNames != null : !((Object)this$annotationNames).equals(other$annotationNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationNameFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $annotationNames = this.getAnnotationNames();
        result = result * 59 + ($annotationNames == null ? 43 : ((Object)$annotationNames).hashCode());
        return result;
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }
}

