/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.TestConfiguration;
import cz.xtf.http.HttpClient;
import cz.xtf.junit.filter.ExclusionTestClassFilter;
import cz.xtf.tuple.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JenkinsRerunFilter
implements ExclusionTestClassFilter {
    private static final Logger log = LoggerFactory.getLogger(JenkinsRerunFilter.class);
    static final int BUILDS_TO_TRY = 20;
    private Set<String> passedClassNames;
    private Set<String> failedClassNames;
    private boolean isEnabled = false;
    private boolean isInitialized = false;

    private HttpClient jenkinsHttpGet(String url, String username, String password) throws IOException, InterruptedException {
        HttpClient client;
        if (StringUtils.isNotBlank((CharSequence)username)) {
            log.info("curl -k --user " + TestConfiguration.ciUsername() + ":<blank> " + url);
            client = HttpClient.get(url).basicAuth(username, password).preemptiveAuth().trustStore(null, (char[])null);
        } else {
            log.info("curl -k " + url);
            client = HttpClient.get(url).trustStore(null, (char[])null);
        }
        return client;
    }

    private HttpClient jenkinsHttpGet(String url) throws IOException, InterruptedException {
        return this.jenkinsHttpGet(url, TestConfiguration.ciUsername(), TestConfiguration.ciPassword());
    }

    private String findJobToRerun() {
        String jobToRerun = null;
        String currentBuildUrl = System.getenv("BUILD_URL");
        Pattern buildNoPattern = Pattern.compile("(.*/)([0-9]+)/$");
        Matcher m = buildNoPattern.matcher(currentBuildUrl);
        if (m.matches()) {
            String prefix = m.group(1);
            String buildNo = m.group(2);
            int build = Integer.parseInt(buildNo);
            int minBuild = build - 20;
            --build;
            while (build >= minBuild) {
                block14: {
                    Tuple.Pair<String, Integer> responseAndCode = null;
                    try {
                        responseAndCode = this.jenkinsHttpGet(prefix + "/" + build + "/api/xml").responseAndCode();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block14;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break block14;
                    }
                    if (responseAndCode.getSecond() == 200) {
                        try {
                            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                            DocumentBuilder db = dbf.newDocumentBuilder();
                            StringReader sr = new StringReader(responseAndCode.getFirst());
                            Document doc = db.parse((InputStream)new ReaderInputStream((Reader)sr));
                            NodeList nodeList = doc.getElementsByTagName("result");
                            int i = 0;
                            if (i < nodeList.getLength()) {
                                Element result = (Element)nodeList.item(i);
                                if (!"ABORTED".equals(result.getTextContent().trim())) break;
                                log.info("ignoring ABORTED build " + prefix + build);
                            }
                        }
                        catch (ParserConfigurationException e) {
                            e.printStackTrace();
                        }
                        catch (SAXException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                --build;
            }
            if (build >= minBuild) {
                log.info("using build " + prefix + build);
                jobToRerun = prefix + build;
            } else {
                log.error("Cannot configure JenkinsRerunFilter, didn't find any non-aborted run");
            }
        } else {
            log.error("Cannot configure JenkinsRerunFilter, failed to parse BUILD_URL {}", (Object)currentBuildUrl);
        }
        return jobToRerun;
    }

    private void lazyInit() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        String jobToRerun = TestConfiguration.testJenkinsRerun();
        this.passedClassNames = new HashSet<String>();
        this.failedClassNames = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)jobToRerun) && ("true".equalsIgnoreCase(jobToRerun) || jobToRerun.startsWith("http"))) {
            if (!jobToRerun.startsWith("http") && (jobToRerun = this.findJobToRerun()) == null) {
                return;
            }
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                String responseXml = this.jenkinsHttpGet(jobToRerun + "/testReport/api/xml").response();
                StringReader sr = new StringReader(responseXml);
                Document doc = db.parse((InputStream)new ReaderInputStream((Reader)sr));
                NodeList nodeList = doc.getElementsByTagName("case");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element caseElement = (Element)nodeList.item(i);
                    String className = caseElement.getElementsByTagName("className").item(0).getTextContent();
                    String status = caseElement.getElementsByTagName("status").item(0).getTextContent();
                    log.trace("className {} status {}", (Object)className, (Object)status);
                    if ("SKIPPED".equals(status)) continue;
                    if ("PASSED".equals(status) || "FIXED".equals(status)) {
                        this.passedClassNames.add(className);
                        continue;
                    }
                    this.failedClassNames.add(className);
                }
                this.isEnabled = true;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean exclude(Class<?> testClass) {
        this.lazyInit();
        if (this.isEnabled) {
            if (!this.failedClassNames.contains(testClass.getName()) && !this.passedClassNames.contains(testClass.getName())) {
                log.debug("Excluding " + testClass.getName() + " not mentioned in previous test results");
                return true;
            }
            if (!this.failedClassNames.contains(testClass.getName()) && this.passedClassNames.contains(testClass.getName())) {
                log.debug("Excluding " + testClass.getName() + " containing only passed tests in previous test results");
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "JenkinsRerunFilter(passedClassNames=" + this.getPassedClassNames() + ", failedClassNames=" + this.getFailedClassNames() + ", isEnabled=" + this.isEnabled + ", isInitialized=" + this.isInitialized + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JenkinsRerunFilter)) {
            return false;
        }
        JenkinsRerunFilter other = (JenkinsRerunFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$passedClassNames = this.getPassedClassNames();
        Set<String> other$passedClassNames = other.getPassedClassNames();
        if (this$passedClassNames == null ? other$passedClassNames != null : !((Object)this$passedClassNames).equals(other$passedClassNames)) {
            return false;
        }
        Set<String> this$failedClassNames = this.getFailedClassNames();
        Set<String> other$failedClassNames = other.getFailedClassNames();
        if (this$failedClassNames == null ? other$failedClassNames != null : !((Object)this$failedClassNames).equals(other$failedClassNames)) {
            return false;
        }
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        return this.isInitialized == other.isInitialized;
    }

    protected boolean canEqual(Object other) {
        return other instanceof JenkinsRerunFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $passedClassNames = this.getPassedClassNames();
        result = result * 59 + ($passedClassNames == null ? 43 : ((Object)$passedClassNames).hashCode());
        Set<String> $failedClassNames = this.getFailedClassNames();
        result = result * 59 + ($failedClassNames == null ? 43 : ((Object)$failedClassNames).hashCode());
        result = result * 59 + (this.isEnabled ? 79 : 97);
        result = result * 59 + (this.isInitialized ? 79 : 97);
        return result;
    }

    public Set<String> getPassedClassNames() {
        return this.passedClassNames;
    }

    public Set<String> getFailedClassNames() {
        return this.failedClassNames;
    }
}

