/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.net.proxy;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import cz.xtf.TestConfiguration;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.net.proxy.ForwardedConnection;
import cz.xtf.openshift.imagestream.ImageRegistry;
import cz.xtf.ssh.SshUtil;
import cz.xtf.util.RandomUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedConnectionManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxiedConnectionManager.class);
    private final String sourceIPs;
    private final String targetHost;
    private final int targetPort;
    private final String containerName = RandomUtil.generateUniqueId("tcp-proxy");
    private Session ssh;
    private int listenPort;

    public ProxiedConnectionManager(String targetHost, int targetPort) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.sourceIPs = TestConfiguration.proxyHostsString();
        this.createTCPProxy();
    }

    public static ProxiedConnectionManager toHTTPRouter() {
        return new ProxiedConnectionManager(OpenShiftNode.router().getIPAddress(), 80);
    }

    public static ProxiedConnectionManager toTLSRouter() {
        return new ProxiedConnectionManager(OpenShiftNode.router().getIPAddress(), 443);
    }

    public ForwardedConnection connect() {
        return new ForwardedConnection(this, this.targetHost, this.targetPort);
    }

    private void createTCPProxy() {
        try {
            String cleanCommand = String.format("sudo docker ps -a | grep 'hours ago' | awk '{print $1}' | xargs --no-run-if-empty sudo docker rm", this.containerName, this.targetHost, this.targetPort, this.sourceIPs, ImageRegistry.get().tcpProxy());
            LOGGER.info("Establishing SSH shell");
            this.ssh = SshUtil.getInstance().createSshSession(TestConfiguration.proxyHostUsername(), this.getProxyHost());
            this.ssh.connect();
            LOGGER.debug("Connected to ssh console");
            ChannelExec cleanChannel = (ChannelExec)this.ssh.openChannel("exec");
            cleanChannel.setPty(true);
            cleanChannel.setCommand(cleanCommand);
            cleanChannel.setInputStream(null);
            cleanChannel.setOutputStream((OutputStream)System.err);
            LOGGER.debug("Executing command: '{}'", (Object)cleanCommand);
            cleanChannel.connect();
            cleanChannel.disconnect();
            String command = String.format("sudo docker run -it --name %s --net=host --rm -e AB_OFF=true -e TARGET_HOST=%s -e TARGET_PORT=%s -e TARGET_VIA=%s %s", this.containerName, this.targetHost, this.targetPort, this.sourceIPs, ImageRegistry.get().tcpProxy());
            LOGGER.info("Establishing SSH shell");
            this.ssh = SshUtil.getInstance().createSshSession(TestConfiguration.proxyHostUsername(), this.getProxyHost());
            this.ssh.connect();
            LOGGER.debug("Connected to ssh console");
            ChannelExec channel = (ChannelExec)this.ssh.openChannel("exec");
            channel.setPty(true);
            channel.setCommand(command);
            channel.setInputStream(null);
            channel.setOutputStream((OutputStream)System.err);
            LOGGER.debug("Executing command: '{}'", (Object)command);
            channel.connect();
            LineIterator li = IOUtils.lineIterator((Reader)new InputStreamReader(channel.getInputStream()));
            Pattern portLine = Pattern.compile(".*Listening on port ([0-9]*).*$");
            this.listenPort = 0;
            while (li.hasNext()) {
                String line = li.next();
                LOGGER.trace("Shell line: {}", (Object)line);
                Matcher m = portLine.matcher(line);
                if (!m.matches()) continue;
                this.listenPort = Integer.parseInt(m.group(1));
                LOGGER.info("Connection listening on port {}", (Object)this.listenPort);
                break;
            }
            channel.disconnect();
        }
        catch (JSchException | IOException e) {
            LOGGER.debug("Error in creating SSH connection to proxy host", e);
            throw new IllegalStateException("Cannot open SSH connection", e);
        }
    }

    @Override
    public void close() {
        LOGGER.info("Closing TCP Proxy on port {}", (Object)this.listenPort);
        try {
            String command = "sudo docker kill " + this.containerName;
            ChannelExec channel = (ChannelExec)this.ssh.openChannel("exec");
            channel.setPty(true);
            channel.setCommand(command);
            channel.setInputStream(null);
            channel.setOutputStream((OutputStream)System.err);
            LOGGER.debug("Executing command: '{}'", (Object)command);
            channel.connect();
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            LOGGER.debug("Killing proxy", (Throwable)e);
        }
        try {
            this.ssh.disconnect();
        }
        catch (Exception e) {
            LOGGER.debug("Disconnecting SSH", (Throwable)e);
        }
    }

    String getProxyHost() {
        return TestConfiguration.proxyHost();
    }

    protected int getListenPort() {
        return this.listenPort;
    }
}

