/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.OpenshiftUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftContext.class);
    public static final String DEFAULT_CONTEXT_NAME = "default";
    public static final String ADMIN_CONTEXT_NAME = "cluster-admin";
    private static final Map<String, OpenShiftContext> REGISTRY = new HashMap<String, OpenShiftContext>();
    private final String username;
    private final String password;
    private final String namespace;
    private String token;

    public static OpenShiftContext getContext() {
        return OpenShiftContext.getContext(DEFAULT_CONTEXT_NAME);
    }

    public static OpenShiftContext getContext(String contextName) {
        return REGISTRY.get(contextName);
    }

    public static OpenShiftContext newContext(String contextName, String username, String password, String namespace) {
        if (DEFAULT_CONTEXT_NAME.equals(contextName)) {
            throw new IllegalArgumentException("Can't override the default context!");
        }
        if (ADMIN_CONTEXT_NAME.equals(contextName)) {
            throw new IllegalArgumentException("Can't override the admin context!");
        }
        if (REGISTRY.containsKey(contextName)) {
            LOGGER.warn("Overriding context '{}'", (Object)contextName);
        }
        OpenShiftContext result = new OpenShiftContext(username, password, namespace, null);
        REGISTRY.put(contextName, result);
        return result;
    }

    public OpenShiftContext(String username, String password, String namespace, String token) {
        this.username = username;
        this.password = password;
        this.namespace = namespace;
        this.token = token;
    }

    public String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getToken() {
        if (this.token == null) {
            this.token = OpenshiftUtil.getInstance().getToken(this.username, this.password);
        }
        return this.token;
    }

    void setToken(String token) {
        this.token = token;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenShiftContext other = (OpenShiftContext)obj;
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    static {
        String username = TestConfiguration.masterUsername();
        String password = TestConfiguration.masterPassword();
        String namespace = TestConfiguration.masterNamespace();
        String token = TestConfiguration.getMasterToken();
        REGISTRY.put(DEFAULT_CONTEXT_NAME, new OpenShiftContext(username, password, namespace, token));
        if (!TestConfiguration.openshiftOnline()) {
            String adminName = TestConfiguration.adminUsername();
            String adminPass = TestConfiguration.adminPassword();
            REGISTRY.put(ADMIN_CONTEXT_NAME, new OpenShiftContext(adminName, adminPass, DEFAULT_CONTEXT_NAME, null));
        }
    }
}

