/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.ProductVersion;

public class VersionRegistry {
    private static final String DEFAULT_VERSION_EAP = "6";
    private static final String DEFAULT_VERSION_EWS = "8";
    private static final String DEFAULT_VERSION_JDG = "6";
    private static VersionRegistry instance;

    private VersionRegistry() {
    }

    public static VersionRegistry get() {
        if (instance == null) {
            instance = new VersionRegistry();
        }
        return instance;
    }

    public ProductVersion eap() {
        String major = TestConfiguration.get().readValue("xtf.version.eap", "6");
        return new ProductVersion(major, TestConfiguration.get().readValue(String.format("%s.%s.string", "xtf.version.eap", major)));
    }

    public boolean isEap6() {
        return this.eap().getMajorVersion().startsWith("6");
    }

    public boolean isEap7() {
        return this.eap().getMajorVersion().startsWith("7");
    }

    public ProductVersion ews() {
        String major = TestConfiguration.get().readValue("xtf.version.ews", DEFAULT_VERSION_EWS);
        return new ProductVersion(major, TestConfiguration.get().readValue(String.format("%s.%s.string", "xtf.version.ews", major)));
    }

    public ProductVersion jdg() {
        String major = "6";
        return new ProductVersion("6", TestConfiguration.get().readValue("xtf.version.jdg"));
    }
}

