/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.buildconfig.BuildStrategy;
import cz.xtf.openshift.builder.buildconfig.DockerBuildStrategy;
import cz.xtf.openshift.builder.buildconfig.ImageSource;
import cz.xtf.openshift.builder.buildconfig.SourceBuildStrategy;
import cz.xtf.openshift.builder.limits.CPUResource;
import cz.xtf.openshift.builder.limits.ComputingResource;
import cz.xtf.openshift.builder.limits.MemoryResource;
import cz.xtf.openshift.builder.limits.ResourceLimitBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BuildConfigBuilder
extends AbstractBuilder<BuildConfig, BuildConfigBuilder>
implements ResourceLimitBuilder {
    public static final String DEFAULT_SECRET = "secret101";
    private String gitUrl;
    private String gitRef;
    private String gitContextDir;
    private String githubSecret = null;
    private String genericSecret = "secret101";
    private String output;
    private String secret;
    private String secretDestinationDir;
    private boolean binaryBuild;
    private BuildStrategy strategy;
    private ImageSource imageSource;
    private Map<String, ComputingResource> computingResources = new HashMap<String, ComputingResource>();

    public BuildConfigBuilder(String name) {
        this(null, name);
    }

    BuildConfigBuilder(ApplicationBuilder applicationBuilder, String name) {
        super(applicationBuilder, name);
    }

    public BuildConfigBuilder gitSource(String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public BuildConfigBuilder gitRef(String gitRef) {
        this.gitRef = gitRef;
        return this;
    }

    public BuildConfigBuilder gitContextDir(String gitContextDir) {
        this.gitContextDir = gitContextDir;
        return this;
    }

    public SourceBuildStrategy sti() {
        if (this.strategy == null) {
            this.strategy = new SourceBuildStrategy(this);
        }
        return (SourceBuildStrategy)this.strategy;
    }

    public DockerBuildStrategy docker() {
        if (this.strategy == null) {
            this.strategy = new DockerBuildStrategy(this);
        }
        return (DockerBuildStrategy)this.strategy;
    }

    public BuildConfigBuilder setOutput(String output) {
        this.output = output;
        try {
            this.app().imageStream(output);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this;
    }

    public BuildConfigBuilder genericWebhook(String secret) {
        this.genericSecret = secret;
        return this;
    }

    public BuildConfigBuilder githubWebhook(String secret) {
        this.githubSecret = secret;
        return this;
    }

    public BuildConfigBuilder withBinaryBuild() {
        this.binaryBuild = true;
        return this;
    }

    public BuildConfigBuilder withSecret(String secretName) {
        this.secret = secretName;
        return this;
    }

    public BuildConfigBuilder withSecret(String secretName, String destinationDir) {
        this.secret = secretName;
        this.secretDestinationDir = destinationDir;
        return this;
    }

    @Override
    public BuildConfig build() {
        LinkedList<BuildTriggerPolicy> triggers = new LinkedList<BuildTriggerPolicy>();
        if (StringUtils.isNotBlank((CharSequence)this.genericSecret)) {
            triggers.add(((BuildTriggerPolicyBuilder)((BuildTriggerPolicyBuilder)new BuildTriggerPolicyBuilder().withType("Generic")).withNewGeneric(Boolean.valueOf(true), this.genericSecret)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)this.githubSecret)) {
            triggers.add(((BuildTriggerPolicyBuilder)((BuildTriggerPolicyBuilder)new BuildTriggerPolicyBuilder().withType("GitHub")).withNewGithub(Boolean.valueOf(true), this.githubSecret)).build());
        }
        BuildSourceBuilder sourceBuilder = new BuildSourceBuilder();
        if (this.binaryBuild) {
            ((BuildSourceBuilder)sourceBuilder.withType("Binary")).withBinary(new BinaryBuildSource());
        } else {
            GitBuildSourceBuilder gitSourceBuilder = (GitBuildSourceBuilder)new GitBuildSourceBuilder().withUri(this.gitUrl);
            if (StringUtils.isNotBlank((CharSequence)this.gitRef)) {
                gitSourceBuilder.withRef(this.gitRef);
            }
            ((BuildSourceBuilder)sourceBuilder.withType("Git")).withGit(gitSourceBuilder.build());
        }
        if (StringUtils.isNotBlank((CharSequence)this.gitContextDir)) {
            sourceBuilder.withContextDir(this.gitContextDir);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.secret})) {
            SecretBuildSourceBuilder sbsb = new SecretBuildSourceBuilder();
            sbsb.withNewSecret(this.secret);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.secretDestinationDir})) {
                sbsb.withDestinationDir(this.secretDestinationDir);
            }
            sourceBuilder.withSecrets(new SecretBuildSource[]{sbsb.build()});
        }
        if (this.imageSource != null) {
            ImageSourceBuilder isb = new ImageSourceBuilder();
            ImageSourceFluent.FromNested from = (ImageSourceFluent.FromNested)((ImageSourceFluent.FromNested)isb.withNewFrom().withName(this.imageSource.getName())).withKind(this.imageSource.getKind());
            if (this.imageSource.getNamespace() != null) {
                from.withNamespace(this.imageSource.getNamespace());
            }
            from.endFrom();
            this.imageSource.getPaths().forEach(x -> {
                ImageSourceBuilder cfr_ignored_0 = (ImageSourceBuilder)((ImageSourceFluent.PathsNested)((ImageSourceFluent.PathsNested)isb.addNewPath().withDestinationDir((String)x.getFirst())).withSourcePath((String)x.getSecond())).endPath();
            });
            sourceBuilder.withImages(new io.fabric8.openshift.api.model.ImageSource[]{isb.build()});
        }
        io.fabric8.openshift.api.model.BuildConfigBuilder builder = (io.fabric8.openshift.api.model.BuildConfigBuilder)new io.fabric8.openshift.api.model.BuildConfigBuilder().withMetadata(this.metadataBuilder().build());
        BuildConfigFluent.SpecNested spec = builder.withNewSpec();
        List requests = this.computingResources.values().stream().filter(x -> x.getRequests() != null).collect(Collectors.toList());
        List limits = this.computingResources.values().stream().filter(x -> x.getLimits() != null).collect(Collectors.toList());
        if (!requests.isEmpty() || !limits.isEmpty()) {
            BuildConfigSpecFluent.ResourcesNested resources = spec.withNewResources();
            if (!requests.isEmpty()) {
                resources.withRequests(requests.stream().collect(Collectors.toMap(ComputingResource::resourceIdentifier, x -> new Quantity(x.getRequests()))));
            }
            if (!limits.isEmpty()) {
                resources.withLimits(limits.stream().collect(Collectors.toMap(ComputingResource::resourceIdentifier, x -> new Quantity(x.getLimits()))));
            }
            resources.endResources();
        }
        ((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)spec.withTriggers(triggers)).withSource(sourceBuilder.build())).withStrategy(this.strategy.build())).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(this.output + ":latest")).endTo()).endOutput()).endSpec();
        return builder.build();
    }

    @Override
    protected BuildConfigBuilder getThis() {
        return this;
    }

    public BuildConfigBuilder imageSource(ImageSource imageSource) {
        this.imageSource = imageSource;
        return this;
    }

    @Override
    public ComputingResource addCPUResource() {
        CPUResource r = new CPUResource();
        this.computingResources.put(((ComputingResource)r).resourceIdentifier(), r);
        return r;
    }

    @Override
    public ComputingResource addMemoryResource() {
        MemoryResource r = new MemoryResource();
        this.computingResources.put(((ComputingResource)r).resourceIdentifier(), r);
        return r;
    }
}

