/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.util;

import cz.xtf.TestConfiguration;
import cz.xtf.TestParent;
import cz.xtf.build.BuildDefinition;
import cz.xtf.build.PathBuildDefinition;
import cz.xtf.build.XTFBuild;
import cz.xtf.io.IOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FisUtils {
    public static void createMavenProxyConf(Path appDirectory) {
        File m2SettingsXml = null;
        if (TestConfiguration.mavenProxyEnabled()) {
            if (!appDirectory.resolve("configuration").toFile().isDirectory()) {
                appDirectory.resolve("configuration").toFile().mkdirs();
            }
            if ((m2SettingsXml = appDirectory.resolve("configuration").resolve("settings.xml").toFile()).isFile()) {
                m2SettingsXml.delete();
            }
            try (FileWriter fw = new FileWriter(m2SettingsXml);){
                fw.write(String.format("<settings>\n  <mirrors>\n    <mirror>\n      <id>s2i-mirror</id>\n      <url>%s</url>\n      <mirrorOf>external:*</mirrorOf>\n    </mirror>\n  </mirrors>\n</settings>\n", TestConfiguration.mavenProxyURL()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static XTFBuild buildWithMavenProxyConf(final XTFBuild build) {
        try {
            IOUtils.TMP_DIRECTORY.toFile().mkdirs();
            Path tmp = Files.createTempDirectory(IOUtils.TMP_DIRECTORY, build.getBuildDefinition().getAppName(), new FileAttribute[0]);
            PathBuildDefinition buildDefinition = (PathBuildDefinition)build.getBuildDefinition();
            IOUtils.copy(buildDefinition.getPathToProject(), tmp);
            Path projectSource = tmp.resolve(buildDefinition.getPathToProject().getFileName());
            FisUtils.createMavenProxyConf(projectSource);
            return new XTFBuild(){

                @Override
                public BuildDefinition getBuildDefinition() {
                    return build.getBuildDefinition();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path pathWithParent(String appName, String parentName) {
        try {
            IOUtils.TMP_DIRECTORY.toFile().mkdirs();
            Path tmpPath = Files.createTempDirectory(IOUtils.TMP_DIRECTORY, appName, new FileAttribute[0]);
            Path appPath = TestParent.findApplicationDirectory("test-fuse", String.format("%s/%s", parentName, appName));
            IOUtils.copy(appPath, tmpPath);
            String parentPom = "parent-fis-" + (parentName.equals("spring-boot") ? "sb" : "karaf");
            if (!IOUtils.TMP_DIRECTORY.resolve(parentPom).toFile().exists()) {
                IOUtils.copy(appPath.getParent().resolve(parentPom), Files.createDirectory(IOUtils.TMP_DIRECTORY.resolve(parentPom), new FileAttribute[0]));
            }
            return tmpPath;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path pathWithMavenProxyConf(String appName, String parentName) {
        Path tmpPath = FisUtils.pathWithParent(appName, parentName);
        FisUtils.createMavenProxyConf(tmpPath);
        return tmpPath;
    }
}

