/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.webdriver;

import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.PodService;
import cz.xtf.openshift.Service;
import cz.xtf.openshift.builder.PodBuilder;
import cz.xtf.openshift.builder.RouteBuilder;
import cz.xtf.openshift.builder.ServiceBuilder;
import cz.xtf.openshift.imagestream.ImageRegistry;
import cz.xtf.wait.WaitUtil;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.openshift.api.model.Route;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhostDriverService
implements Service {
    private static final int PHANTOMJS_DEPLOY_TIMEOUT_SECONDS = 600;
    private static final Logger LOGGER = LoggerFactory.getLogger(GhostDriverService.class);
    private Pod ghostDriverPod = null;
    private String hostName = null;
    private static GhostDriverService instance;
    private PodService podService = null;
    private int localPort;

    public static synchronized GhostDriverService get() {
        if (instance == null) {
            instance = new GhostDriverService();
        }
        return instance;
    }

    @Override
    public synchronized boolean isStarted() throws Exception {
        return this.ghostDriverPod != null;
    }

    @Override
    public synchronized void start() {
        Optional<Pod> p;
        if (this.ghostDriverPod != null) {
            p = OpenshiftUtil.getInstance().getPods().stream().filter(pod -> pod.getMetadata().getName().equals(this.ghostDriverPod.getMetadata().getName())).findFirst();
            if (!p.isPresent()) {
                this.ghostDriverPod = null;
            }
        } else {
            Optional<Route> route;
            p = OpenshiftUtil.getInstance().getPods().stream().filter(pod -> pod.getMetadata().getName().equals("phantomjs")).findFirst();
            if (p.isPresent() && (route = OpenshiftUtil.getInstance().getRoutes().stream().filter(pod -> pod.getMetadata().getName().startsWith("phantomjs")).findFirst()).isPresent()) {
                this.ghostDriverPod = p.get();
                this.hostName = route.get().getSpec().getHost();
                try {
                    WaitUtil.waitFor(WaitUtil.urlReturnsCode("http://" + this.hostName + "/status", 200), null, 1000L, 600000L);
                    this.podService = new PodService(this.ghostDriverPod);
                    this.localPort = this.podService.portForward(4444);
                }
                catch (Exception x) {
                    LOGGER.error("PhantomJS at {} not started after {} s", new Object[]{this.hostName, 600, x});
                }
                return;
            }
        }
        if (this.ghostDriverPod == null) {
            ServiceBuilder sb = new ServiceBuilder("phantomjs");
            sb.addLabel("name", "phantomjs");
            sb.addContainerSelector("name", "phantomjs");
            sb.setContainerPort(4444);
            PodBuilder pb = new PodBuilder("phantomjs");
            pb.addLabel("name", "phantomjs");
            pb.gracefulShutdown(0);
            pb.container().envVar("IGNORE_SSL_ERRORS", "true").fromImage(ImageRegistry.get().phantomJs()).port(4444, "webdriver");
            OpenshiftUtil.getInstance().createService(sb.build());
            this.ghostDriverPod = pb.build();
            OpenshiftUtil.getInstance().createPod(this.ghostDriverPod);
            this.hostName = RouteBuilder.createHostName("phantomjs");
            RouteBuilder rb = new RouteBuilder("phantomjs");
            ((RouteBuilder)rb.addLabel("name", "phantomjs")).forService("phantomjs").exposedAsHost(this.hostName);
            OpenshiftUtil.getInstance().createRoute(rb.build());
            try {
                WaitUtil.waitFor(WaitUtil.urlReturnsCode("http://" + this.hostName + "/status", 200), null, 1000L, 600000L);
                this.podService = new PodService(this.ghostDriverPod);
                this.localPort = this.podService.portForward(4444);
            }
            catch (Exception x) {
                LOGGER.error("PhantomJS at {} not started after {} s", new Object[]{this.hostName, 600, x});
            }
        }
    }

    @Override
    public synchronized String getHostName() {
        return this.hostName;
    }

    @Override
    public synchronized void close() {
        if (this.ghostDriverPod != null) {
            Predicate<HasMetadata> isPhantomJs = resource -> "phantomjs".equals(resource.getMetadata().getLabels().get("name"));
            OpenshiftUtil.getInstance().getPods().stream().filter(isPhantomJs).forEach(OpenshiftUtil.getInstance()::deletePod);
            OpenshiftUtil.getInstance().getServices().stream().filter(isPhantomJs).forEach(OpenshiftUtil.getInstance()::deleteService);
            this.ghostDriverPod = null;
            try {
                this.podService.close();
            }
            catch (Exception e) {
                LOGGER.error("Error closing podService", (Throwable)e);
            }
            this.podService = null;
        }
    }

    public synchronized int getLocalPort() {
        return this.localPort;
    }
}

