/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf;

import cz.xtf.TestConfiguration;
import cz.xtf.openshift.VersionRegistry;

public class TestProjectProfileResolver {
    private static TestProjectProfileResolver instance;

    private TestProjectProfileResolver() {
    }

    public static TestProjectProfileResolver get() {
        if (instance == null) {
            instance = new TestProjectProfileResolver();
        }
        return instance;
    }

    public String getProfileName(String parentModuleName) {
        String prefix = this.getProfileNamePrefix(parentModuleName);
        String suffix = this.getProfileNameSuffix(parentModuleName);
        if (prefix == null || suffix == null) {
            return null;
        }
        return prefix + "-" + suffix;
    }

    public String getProfileNamePrefix(String parentModuleName) {
        switch (parentModuleName) {
            case "parent-eap": {
                return "eap";
            }
            case "parent-fis": {
                return null;
            }
            case "parent-fis-sb": {
                return null;
            }
            case "parent-fis-karaf": {
                return null;
            }
            case "parent-msa-sb": 
            case "parent-msa-vertx": 
            case "parent-msa-wildfly-swarm": {
                return "msa";
            }
        }
        throw new IllegalArgumentException("Unknown parent module name");
    }

    public String getProfileNameSuffix(String parentModuleName) {
        switch (parentModuleName) {
            case "parent-eap": {
                return VersionRegistry.get().eap().getMajorVersion();
            }
            case "parent-fis": {
                return null;
            }
            case "parent-fis-sb": {
                return null;
            }
            case "parent-fis-karaf": {
                return null;
            }
            case "parent-msa-sb": 
            case "parent-msa-vertx": 
            case "parent-msa-wildfly-swarm": {
                return TestConfiguration.getMsaVersion();
            }
        }
        throw new IllegalArgumentException("Unknown parent module name");
    }
}

