/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import cz.xtf.build.BuildProcess;
import cz.xtf.build.PathBuildDefinition;
import cz.xtf.build.PathBuildProcess;
import cz.xtf.git.PomModifier;
import cz.xtf.io.IOUtils;
import cz.xtf.maven.MavenUtil;
import cz.xtf.openshift.OpenShiftBinaryClient;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.it.VerificationException;

public class PathBinaryBuildProcess
extends PathBuildProcess {
    private Path appTmpDir;
    private Path appTmpSourceDir;
    private Path appTmpArtifactsDir;
    private Path appTmpDeploymentsDir;
    private Path appTmpConfigurationDir;

    public PathBinaryBuildProcess(PathBuildDefinition definition) {
        super(definition);
    }

    @Override
    public void deployBuild() {
        this.createDirectoriesStructure();
        this.runMavenBuild();
        this.copyArtefacts();
        this.createResources();
        this.startBuildFromDirectory();
    }

    @Override
    public void deleteBuild() {
        this.deleteOpenshiftResources();
    }

    @Override
    public BuildProcess.BuildStatus getBuildStatus() {
        return this.getCommonStatus(this.getBuildConfig());
    }

    @Override
    public void updateBuild() {
        throw new UnsupportedOperationException("Yet not implemented");
    }

    private void createDirectoriesStructure() {
        IOUtils.TMP_DIRECTORY.toFile().mkdirs();
        try {
            this.appTmpDir = Files.createTempDirectory(IOUtils.TMP_DIRECTORY, this.buildName, new FileAttribute[0]);
            this.appTmpSourceDir = this.appTmpDir.resolve("source");
            this.appTmpArtifactsDir = this.appTmpDir.resolve("artifacts");
            this.appTmpDeploymentsDir = this.appTmpArtifactsDir.resolve("deployments");
            this.appTmpConfigurationDir = this.appTmpArtifactsDir.resolve("configuration");
            this.appTmpSourceDir.toFile().mkdir();
            this.appTmpArtifactsDir.toFile().mkdir();
            this.appTmpDeploymentsDir.toFile().mkdir();
            this.appTmpConfigurationDir.toFile().mkdir();
            IOUtils.copy(this.pathToProject, this.appTmpSourceDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary directories structure", e);
        }
    }

    private void runMavenBuild() {
        if (this.appTmpSourceDir.resolve("pom.xml").toFile().exists()) {
            new PomModifier(this.pathToProject.toAbsolutePath(), this.appTmpSourceDir).modify();
            try {
                MavenUtil.forProject(this.appTmpSourceDir).forkJvm().executeGoals("clean", "package");
            }
            catch (VerificationException e) {
                throw new IllegalStateException("Failed to run local maven build on project", e);
            }
        }
    }

    private void copyArtefacts() {
        try {
            if (this.appTmpSourceDir.resolve("pom.xml").toFile().exists()) {
                if (this.appTmpSourceDir.resolve("target").toFile().exists()) {
                    for (File file : this.appTmpSourceDir.resolve("target").toFile().listFiles(new ArchivesFileFilter())) {
                        IOUtils.copy(Paths.get(file.getPath(), new String[0]), this.appTmpDeploymentsDir);
                    }
                } else {
                    throw new IllegalStateException("Didn't found target directory in builded app, multiprojects aren't supported");
                }
            }
            if (this.appTmpSourceDir.resolve("configuration").toFile().exists()) {
                IOUtils.copy(this.appTmpSourceDir.resolve("configuration"), this.appTmpConfigurationDir);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy build artifacts", e);
        }
    }

    private void createResources() {
        this.deployResources(this.getPreconfiguredBuildConfig().withBinaryBuild().build());
    }

    private void startBuildFromDirectory() {
        OpenShiftBinaryClient.getInstance().executeCommandNoWait("error starting build with oc", "start-build", this.buildName, "-n", this.buildNamespace, "--from-dir=" + this.appTmpArtifactsDir);
    }

    public static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    public static class ArchivesFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.toString().matches(".*(\\.war|\\.jar|\\.ear|\\.rar)");
        }
    }
}

