/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.docker;

import cz.xtf.docker.OpenShiftNode;
import cz.xtf.openshift.OpenshiftUtil;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerContainer.class);
    private OpenShiftNode node;
    private String containerId;

    private DockerContainer(String host, String containerId) {
        this.node = new OpenShiftNode(host.equals("localhost.localdomain") ? "10.1.2.2" : host);
        this.containerId = containerId;
    }

    public static DockerContainer createForRouter() {
        Collection pods = OpenshiftUtil.getInstance().withAdminUser(client -> ((PodList)((NamespacedOpenShiftClient)client.inNamespace("default")).pods().list()).getItems());
        for (Pod pod : pods) {
            if (!pod.getMetadata().getName().startsWith("router-")) continue;
            return DockerContainer.createForPod(pod, "router");
        }
        return null;
    }

    public static DockerContainer createForPod(Pod pod) {
        return DockerContainer.createForPod(pod, (String)pod.getMetadata().getLabels().get("name"));
    }

    public static DockerContainer createForPod(Pod pod, String containerLabel) {
        String host = pod.getSpec().getNodeName();
        String containerId = URI.create(pod.getStatus().getContainerStatuses().stream().filter(containerStats -> containerStats.getName().equals(containerLabel)).findFirst().get().getContainerID()).getHost();
        return new DockerContainer(host, containerId);
    }

    public String dockerCmd(Function<String, String> cmdFunc) {
        LOGGER.debug("dockerCmd host = " + this.node + ", containerId = " + this.containerId);
        return this.node.executeCommand("sudo " + cmdFunc.apply(this.containerId)).trim();
    }

    public void dockerCmd(Function<String, String> cmdFunc, OpenShiftNode.CommandResultConsumer resultConsumer) {
        LOGGER.debug("dockerCmd host = " + this.node + ", containerId = " + this.containerId);
        this.node.executeCommand(true, "sudo " + cmdFunc.apply(this.containerId), resultConsumer);
    }

    private boolean dockerCmdReturningContainerIdOnSuccess(Function<String, String> cmdFunc) {
        AtomicReference<Object> expectedResult = new AtomicReference<Object>(null);
        String result = this.dockerCmd(containerId -> {
            expectedResult.set(containerId);
            return (String)cmdFunc.apply((String)containerId);
        }).trim();
        return result.equals(expectedResult.get());
    }

    public void dockerPause() {
        boolean ret = this.dockerCmdReturningContainerIdOnSuccess(containerId -> "docker pause " + containerId);
        Assertions.assertThat((boolean)ret).isEqualTo(true).as("Error executing docker pause", new Object[0]);
    }

    public void dockerUnPause() {
        boolean ret = this.dockerCmdReturningContainerIdOnSuccess(containerId -> "docker unpause " + containerId);
        Assertions.assertThat((boolean)ret).isEqualTo(true).as("Error executing docker unpause", new Object[0]);
    }

    public boolean isRunning() {
        return Boolean.parseBoolean(this.dockerCmd(containerId -> " docker inspect -f '{{.State.Running}}'  " + containerId));
    }

    public void dockerJvmKill() {
        String javaPid = this.dockerCmd(containerId -> "docker exec " + containerId + " /bin/sh -c '(for i in `ls /proc/*/exe`; do j=`readlink $i`; echo $i $j; done) | grep java | cut -d'/' -f3'").trim().replace('\n', ' ');
        LOGGER.debug("dockerJvmKill java pid: " + javaPid);
        String ret = this.dockerCmd(containerId -> "docker exec " + containerId + " kill -9 " + javaPid).trim();
        LOGGER.debug("dockerJvmKill kill output:" + ret);
    }

    public void dockerKill(String signal) {
        boolean ret = this.dockerCmdReturningContainerIdOnSuccess(containerId -> "docker kill --signal=" + signal + " " + containerId);
        Assertions.assertThat((boolean)ret).isEqualTo(true).as("Error executing docker kill", new Object[0]);
    }

    public void dockerKill() {
        this.dockerKill("KILL");
    }

    public void dockerStop() {
        boolean ret = this.dockerCmdReturningContainerIdOnSuccess(containerId -> "docker stop " + containerId);
        Assertions.assertThat((boolean)ret).isEqualTo(true).as("Error executing docker stop", new Object[0]);
    }

    @Deprecated
    public String dockerLogs() {
        return this.dockerCmd(containerId -> "docker logs " + containerId);
    }

    public void dockerLogs(OpenShiftNode.CommandResultConsumer resultConsumer) {
        this.dockerCmd(containerId -> "docker logs " + containerId, resultConsumer);
    }

    public String findLineInLog(String regex) {
        LOGGER.info("Parse logs");
        AtomicReference soughtLine = new AtomicReference();
        Pattern pattern = Pattern.compile(".*" + regex + ".*", 2);
        this.dockerLogs(stream -> IOUtils.lineIterator((InputStream)stream, (String)StandardCharsets.UTF_8.toString()).forEachRemaining(line -> {
            Matcher m = pattern.matcher((CharSequence)line);
            if (m.matches()) {
                soughtLine.set(line);
            }
        }));
        return (String)soughtLine.get();
    }

    public OpenShiftNode getOpenShiftNode() {
        return this.node;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String toString() {
        return "DockerContainer [node=" + this.node + ", containerId=" + this.containerId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerContainer that = (DockerContainer)o;
        if (this.node != null ? !this.node.getHostname().equals(that.node.getHostname()) : that.node != null) {
            return false;
        }
        return !(this.containerId == null ? that.containerId != null : !this.containerId.equals(that.containerId));
    }

    public int hashCode() {
        int result = this.node != null ? this.node.getHostname().hashCode() : 0;
        result = 31 * result + (this.containerId != null ? this.containerId.hashCode() : 0);
        return result;
    }
}

