/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.docker;

import cz.xtf.docker.DockerContainer;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class InContainerCommandExecutor {
    private DockerContainer dockerContainer;

    public static InContainerCommandExecutor inPod(Pod pod) {
        return new InContainerCommandExecutor(pod);
    }

    private InContainerCommandExecutor(Pod pod) {
        this.dockerContainer = DockerContainer.createForPod(pod);
    }

    public List<String> listDirContent(String path) {
        String cmd = String.format("ls -1 %s", path);
        return this.executeBashCommandAndExpectList(cmd);
    }

    public List<String> listFullDirContent(String path) {
        String cmd = String.format("ls -a1 %s", path);
        return this.executeBashCommandAndExpectList(cmd);
    }

    public Map<String, String> listEnvs() {
        HashMap<String, String> containerEnv = new HashMap<String, String>();
        Stream.of(this.executeCommand("env").split("\n")).forEach(env -> {
            String[] parsedEnv = env.split("=", 2);
            containerEnv.put(parsedEnv[0], parsedEnv[1]);
        });
        return containerEnv;
    }

    public String executeBashCommand(String command) {
        String cmd = String.format("bash -c \"%s\"", command);
        return this.executeCommand(cmd);
    }

    public String executeCommand(String command) {
        return this.dockerContainer.dockerCmd(containerID -> String.format("docker exec %s %s", containerID, command));
    }

    public List<String> executeBashCommandAndExpectList(String command) {
        String cmd = String.format("bash -c \"%s\"", command);
        return this.executeCommandAndExpectList(cmd);
    }

    public List<String> executeCommandAndExpectList(String command) {
        String[] result = StringUtils.split((String)this.executeCommand(command), (char)'\n');
        return Arrays.asList(result);
    }
}

