/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.junit.annotation.JavaS2IProfile;
import cz.xtf.junit.annotation.SpringBootProfile;
import cz.xtf.junit.annotation.VertxProfile;
import cz.xtf.junit.annotation.WildFlySwarmProfile;
import cz.xtf.junit.filter.ExclusionTestClassFilter;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class MsaProfileFilter
implements ExclusionTestClassFilter {
    public static final String MSA_PROVIDER_PROPERTY = "xtf.msa.provider";
    protected final String msaProvider = System.getProperty("xtf.msa.provider", "none");

    @Override
    public boolean exclude(Class<?> testClass) {
        for (Annotation annotation : Arrays.asList(testClass.getAnnotations())) {
            if (annotation instanceof VertxProfile && "vertx".equals(this.msaProvider)) {
                return false;
            }
            if (annotation instanceof SpringBootProfile && "springboot".equals(this.msaProvider)) {
                return false;
            }
            if (annotation instanceof WildFlySwarmProfile && "wildfly-swarm".equals(this.msaProvider)) {
                return false;
            }
            if (!(annotation instanceof JavaS2IProfile) || !"java-s2i".equals(this.msaProvider)) continue;
            return false;
        }
        return true;
    }
}

