/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.manipulation;

import cz.xtf.UsageRecorder;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ImageStreamBuilder;
import cz.xtf.openshift.imagestream.ImageStreamRequest;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageStreamProcessor {
    private static final Logger log = LoggerFactory.getLogger(ImageStreamProcessor.class);
    public static final String IS_NAMESPACE = "openshift";

    private ImageStreamProcessor() {
    }

    public static void createImageStream(ImageStreamRequest request) {
        ImageStreamProcessor.createImageStream(request.getName(), request.getImage(), request.getTags());
    }

    public static void createImageStream(String name, String fromImage, List<String> customTags) {
        ImageStreamProcessor.createImageStream(name, fromImage, customTags.toArray(new String[customTags.size()]));
    }

    public static void createImageStream(String name, String fromImage, String ... customTags) {
        UsageRecorder.recordImage(name, fromImage);
        OpenshiftUtil openshift = OpenshiftUtil.getInstance();
        ImageStreamBuilder isBuilder = new ImageStreamBuilder(name).insecure().fromExternalImage(fromImage);
        for (String tag : customTags) {
            isBuilder.addTag(tag, fromImage);
        }
        ImageStream is = isBuilder.build();
        log.info("action=create-image-stream status=START name={} image={} tags={}", new Object[]{name, fromImage, customTags});
        openshift.withAdminUser(client -> (Boolean)((ClientResource)((NamespacedOpenShiftClient)client.inNamespace(IS_NAMESPACE)).imageStreams().withName(name)).delete());
        openshift.withAdminUser(client -> (ImageStream)((NamespacedOpenShiftClient)client.inNamespace(IS_NAMESPACE)).imageStreams().create((Object[])new ImageStream[]{is}));
        log.info("action=create-image-stream status=FINISH name={} image={} tags={}", new Object[]{name, fromImage, customTags});
    }
}

