/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.EnvironmentConfiguration;
import io.fabric8.kubernetes.api.model.ConfigMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConfigMapBuilder
extends AbstractBuilder<ConfigMap, ConfigMapBuilder>
implements EnvironmentConfiguration {
    private final Map<String, String> config = new HashMap<String, String>();
    private Function<String, String> nameTransformationFunction = Function.identity();

    public ConfigMapBuilder(String name) {
        super(null, name);
    }

    @Override
    public ConfigMap build() {
        return ((io.fabric8.kubernetes.api.model.ConfigMapBuilder)((io.fabric8.kubernetes.api.model.ConfigMapBuilder)new io.fabric8.kubernetes.api.model.ConfigMapBuilder().withMetadata(this.metadataBuilder().build())).withData(this.config.entrySet().stream().collect(Collectors.toMap(x -> this.nameTransformationFunction.apply((String)x.getKey()), Map.Entry::getValue)))).build();
    }

    @Override
    protected ConfigMapBuilder getThis() {
        return this;
    }

    @Override
    public ConfigMapBuilder configEntry(String key, String value) {
        this.config.put(this.nameTransformationFunction.apply(key), value);
        return this;
    }

    @Override
    public Map<String, String> getConfigEntries() {
        return this.config;
    }

    public ConfigMapBuilder transformNames(Function<String, String> nameTransformation) {
        this.nameTransformationFunction = nameTransformation;
        return this;
    }

    public static Function<String, String> toEnvVarFormat() {
        return x -> x.toUpperCase().replace('-', '_');
    }

    public static Function<String, String> fromEnvVarFormat() {
        return x -> x.toLowerCase().replace('_', '-');
    }
}

