/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Collections;

public class PVCBuilder
extends AbstractBuilder<PersistentVolumeClaim, PVCBuilder> {
    private AccessMode accessMode;
    private String storageRequest;

    public PVCBuilder(String name) {
        this(null, name);
    }

    PVCBuilder(ApplicationBuilder applicationBuilder, String name) {
        super(applicationBuilder, name);
    }

    public PVCBuilder accessRWO() {
        this.accessMode = AccessMode.ReadWriteOnce;
        return this;
    }

    public PVCBuilder accessRWX() {
        this.accessMode = AccessMode.ReadWriteMany;
        return this;
    }

    public PVCBuilder accessROX() {
        this.accessMode = AccessMode.ReadOnlyMany;
        return this;
    }

    public PVCBuilder storageSize(String storageRequest) {
        this.storageRequest = storageRequest;
        return this;
    }

    @Override
    public PersistentVolumeClaim build() {
        ObjectMetaBuilder meta = (ObjectMetaBuilder)new ObjectMetaBuilder().withName(this.getName());
        return ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)new PersistentVolumeClaimBuilder().withMetadata(this.metadataBuilder().build())).withNewSpec().withAccessModes(new String[]{this.accessMode.toString()})).withNewResources().withRequests(Collections.singletonMap("storage", new Quantity(this.storageRequest)))).endResources()).endSpec()).build();
    }

    @Override
    protected PVCBuilder getThis() {
        return this;
    }

    private static enum AccessMode {
        ReadWriteOnce,
        ReadWriteMany,
        ReadOnlyMany;

    }
}

