/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.sso.api;

import cz.xtf.sso.api.SsoApi;
import cz.xtf.sso.api.SsoRestApi;
import cz.xtf.sso.api.SsoWebUIApi;

public class SsoApiFactory {
    public static final SsoApiType DEFAULT_API_TYPE = SsoApiType.REST;

    public static SsoApi get(String authUrl, String realm) {
        return SsoApiFactory.get(authUrl, realm, DEFAULT_API_TYPE);
    }

    public static SsoApi get(String authUrl, String realm, SsoApiType type) {
        switch (type) {
            case REST: {
                return SsoApiFactory.getRestApi(authUrl, realm);
            }
            case WEBUI: {
                return SsoApiFactory.getWebUIApi(authUrl, realm);
            }
        }
        return SsoApiFactory.getRestApi(authUrl, realm);
    }

    public static SsoApi getRestApi(String authUrl, String realm) {
        return SsoRestApi.get(authUrl, realm);
    }

    public static SsoApi getWebUIApi(String authUrl, String realm) {
        return SsoWebUIApi.get(authUrl, realm);
    }

    public static enum SsoApiType {
        REST,
        WEBUI;

    }
}

