/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.sso.api;

import cz.xtf.sso.api.ProtocolType;
import cz.xtf.sso.api.Provider;
import cz.xtf.sso.api.SsoApi;
import cz.xtf.sso.api.entity.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoRestApi
implements SsoApi {
    private static final Logger log = LoggerFactory.getLogger(SsoRestApi.class);
    private final String realmName;
    private final String authUrl;
    private Keycloak client;

    public static SsoRestApi get(String authUrl, String realm) {
        return new SsoRestApi(authUrl, realm);
    }

    private SsoRestApi(String authUrl, String realmName) {
        if (authUrl.contains("https://")) {
            throw new UnsupportedOperationException("Rest api does not work through https withing openshift router, see (there is issue somewhere)");
        }
        this.realmName = realmName;
        this.authUrl = authUrl;
        this.initClient();
    }

    public void initClient() {
        this.client = Keycloak.getInstance((String)this.authUrl, (String)"master", (String)"admin", (String)"admin", (String)"admin-cli");
    }

    public <R> R withKeycloakClient(Function<Keycloak, R> f) {
        return f.apply(this.client);
    }

    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String createUser(String username, String password, String firstname, String lastname, String email, List<String> rolenames) {
        if (username.equals("user")) {
            throw new UnsupportedOperationException("Dont't do that! (Sso rest api doesn't create user with username 'user' properly)");
        }
        CredentialRepresentation cr = new CredentialRepresentation();
        cr.setType("password");
        cr.setValue(password);
        cr.setTemporary(Boolean.valueOf(false));
        UserRepresentation ur = new UserRepresentation();
        ur.setUsername(username);
        ur.setCredentials(Arrays.asList(cr));
        ur.setFirstName(firstname);
        ur.setLastName(lastname);
        ur.setEmail(email);
        ur.setEnabled(Boolean.valueOf(true));
        Response response = this.client.realm(this.realmName).users().create(ur);
        response.close();
        String userId = this.getUserId(username);
        this.client.realm(this.realmName).users().get(userId).resetPassword(cr);
        if (rolenames != null && rolenames.size() > 0) {
            this.addRealmRolesToUser(userId, rolenames);
        }
        return userId;
    }

    @Override
    public void createRole(String rolename) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(rolename);
        this.client.realm(this.realmName).roles().create(role);
    }

    @Override
    public String createOidcBearerClient(String clientName) {
        ClientRepresentation cr = new ClientRepresentation();
        cr.setName(clientName);
        cr.setClientId(clientName);
        cr.setProtocol(ProtocolType.OPENID_CONNECT.getLabel());
        cr.setBearerOnly(Boolean.valueOf(true));
        cr.setPublicClient(Boolean.valueOf(false));
        cr.setEnabled(Boolean.valueOf(true));
        this.createClient(cr);
        return this.getClientId(clientName);
    }

    @Override
    public String createOicdConfidentialClient(String clientName, String rootUrl, List<String> redirectUris, String baseUrl, String adminUrl) {
        ClientRepresentation cr = new ClientRepresentation();
        cr.setName(clientName);
        cr.setClientId(clientName);
        cr.setProtocol(ProtocolType.OPENID_CONNECT.getLabel());
        cr.setAdminUrl(adminUrl);
        cr.setRootUrl(rootUrl);
        cr.setBaseUrl(baseUrl);
        cr.setRedirectUris(redirectUris);
        cr.setBearerOnly(Boolean.valueOf(false));
        cr.setPublicClient(Boolean.valueOf(false));
        cr.setEnabled(Boolean.valueOf(true));
        this.createClient(cr);
        this.createClient(cr);
        return this.getClientId(clientName);
    }

    @Override
    public String createInsecureSamlClient(String clientName, String masterSamlUrl, String baseUrl, List<String> redirectUris) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("saml.server.signature", "false");
        attributes.put("saml.client.signature", "false");
        ClientRepresentation cr = new ClientRepresentation();
        cr.setName(clientName);
        cr.setClientId(clientName);
        cr.setProtocol(ProtocolType.SAML.getLabel());
        cr.setEnabled(Boolean.valueOf(true));
        cr.setAdminUrl(masterSamlUrl);
        cr.setBaseUrl(baseUrl);
        cr.setRedirectUris(redirectUris);
        cr.setAttributes(attributes);
        this.createClient(cr);
        return this.getClientId(clientName);
    }

    @Override
    public String createOidcPublicClient(String clientName, String rootUrl, List<String> redirectUris, List<String> webOrigins) {
        ClientRepresentation cr = new ClientRepresentation();
        cr.setName(clientName);
        cr.setClientId(clientName);
        cr.setProtocol(ProtocolType.OPENID_CONNECT.getLabel());
        cr.setPublicClient(Boolean.valueOf(true));
        cr.setEnabled(Boolean.valueOf(true));
        cr.setRootUrl(rootUrl);
        cr.setRedirectUris(redirectUris);
        cr.setWebOrigins(webOrigins);
        this.createClient(cr);
        return this.getClientId(clientName);
    }

    private void createClient(ClientRepresentation cr) {
        Response response = this.client.realm(this.realmName).clients().create(cr);
        response.close();
    }

    @Override
    public void addRealmRolesToUser(String userId, List<String> rolenames) {
        List roles = this.client.realm(this.realmName).users().get(userId).roles().realmLevel().listAvailable().stream().filter(r -> rolenames.contains(r.getName())).collect(Collectors.toList());
        this.client.realm(this.realmName).users().get(userId).roles().realmLevel().add(roles);
    }

    @Override
    public void addBultinMappersToSamlClient(String clientId) {
        ArrayList<ProtocolMapperRepresentation> builtInMappers = new ArrayList<ProtocolMapperRepresentation>();
        builtInMappers.add(this.getX500GivenNameMapper());
        builtInMappers.add(this.getX500SurnameMapper());
        builtInMappers.add(this.getX500EmailBuiltInMapper());
        this.client.realm(this.realmName).clients().get(clientId).getProtocolMappers().createMapper(builtInMappers);
    }

    @Override
    public String getUserId(String username) {
        return ((UserRepresentation)this.client.realm(this.realmName).users().search(username, Integer.valueOf(0), Integer.valueOf(1)).get(0)).getId();
    }

    @Override
    public String getClientId(String clientName) {
        return this.client.realm(this.realmName).clients().findAll().stream().filter(cr -> cr.getClientId().equals(clientName)).findFirst().get().getId();
    }

    @Override
    public String getRealmId() {
        return this.client.realm(this.realmName).toRepresentation().getId();
    }

    @Override
    public String getRealmPublicKey() {
        return this.client.realm(this.realmName).toRepresentation().getPublicKey();
    }

    @Override
    public String getOicdInstallationXmlFile(String clientId) {
        return this.client.realm(this.realmName).clients().get(clientId).getInstallationProvider(Provider.OIDC_JBOSS_XML_SUBSYSTEM.getProviderId());
    }

    @Override
    public String getSamlInstallationXmlFile(String clientId) {
        return this.client.realm(this.realmName).clients().get(clientId).getInstallationProvider(Provider.SAML_JBOSS_XML_SUBSYSTEM.getProviderId());
    }

    @Override
    public String getJsonInstallationFile(String clientId) {
        return this.client.realm(this.realmName).clients().get(clientId).getInstallationProvider(Provider.OIDC_KEYCLOAK_JSON.getProviderId());
    }

    @Override
    public void updateUserDetails(User user) {
        UserRepresentation ur = this.client.realm(this.realmName).users().get(user.id).toRepresentation();
        ur.setFirstName(user.firstName);
        ur.setLastName(user.lastName);
        ur.setEmail(user.email);
        this.client.realm(this.realmName).users().get(user.id).update(ur);
    }

    @Override
    public void deleteUser(String userId) {
        Response response = this.client.realm(this.realmName).users().delete(userId);
        response.close();
    }

    @Override
    public void forceNameIdFormat(String clientId) {
        ClientRepresentation cr = this.client.realm(this.realmName).clients().get(clientId).toRepresentation();
        cr.getAttributes().put("saml_force_name_id_format", "true");
        this.client.realm(this.realmName).clients().get(clientId).update(cr);
    }

    @Override
    public void updateClientRedirectUri(String clientId, List<String> redirectUris) {
        ClientRepresentation cr = new ClientRepresentation();
        cr.setRedirectUris(redirectUris);
        this.client.realm(this.realmName).clients().get(clientId).update(cr);
    }

    private ProtocolMapperRepresentation getX500GivenNameMapper() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        properties.put("user.attribute", "firstName");
        properties.put("friendly.name", "givenName");
        properties.put("attribute.name", "urn:oid:2.5.4.42");
        ProtocolMapperRepresentation pmr = new ProtocolMapperRepresentation();
        pmr.setProtocol("saml");
        pmr.setName("X500 givenName");
        pmr.setConsentRequired(true);
        pmr.setConsentText("${givenName}");
        pmr.setProtocolMapper("saml-user-property-mapper");
        pmr.setConfig(properties);
        return pmr;
    }

    private ProtocolMapperRepresentation getX500SurnameMapper() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        properties.put("user.attribute", "lastName");
        properties.put("friendly.name", "surname");
        properties.put("attribute.name", "urn:oid:2.5.4.4");
        ProtocolMapperRepresentation pmr = new ProtocolMapperRepresentation();
        pmr.setProtocol("saml");
        pmr.setName("X500 surname");
        pmr.setConsentRequired(true);
        pmr.setConsentText("${familyName}");
        pmr.setProtocolMapper("saml-user-property-mapper");
        pmr.setConfig(properties);
        return pmr;
    }

    private ProtocolMapperRepresentation getX500EmailBuiltInMapper() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("attribute.nameformat", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        properties.put("user.attribute", "email");
        properties.put("friendly.name", "email");
        properties.put("attribute.name", "urn:oid:1.2.840.113549.1.9.1");
        ProtocolMapperRepresentation pmr = new ProtocolMapperRepresentation();
        pmr.setProtocol("saml");
        pmr.setName("X500 email");
        pmr.setConsentRequired(true);
        pmr.setConsentText("${email}");
        pmr.setProtocolMapper("saml-user-property-mapper");
        pmr.setConfig(properties);
        return pmr;
    }
}

