/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import cz.xtf.TestConfiguration;
import cz.xtf.build.BuildDefinition;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.BuildConfigBuilder;
import cz.xtf.openshift.builder.ImageStreamBuilder;
import cz.xtf.openshift.builder.buildconfig.SourceBuildStrategy;
import cz.xtf.wait.WaitUtil;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.ImageStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildProcess {
    private static final Logger log = LoggerFactory.getLogger(BuildProcess.class);
    protected final OpenshiftUtil openshift = OpenshiftUtil.getInstance();
    protected final BuildDefinition definition;
    protected final String buildNamespace = TestConfiguration.buildNamespace();
    protected final String buildName;

    public BuildProcess(BuildDefinition definition) {
        this.definition = definition;
        this.buildName = definition.getName();
    }

    protected BuildConfig getBuildConfig() {
        return this.openshift.getBuildConfig(this.buildName, this.buildNamespace);
    }

    public abstract void deployBuild();

    protected void deployBuildFromGit(String gitRepo) {
        this.deployBuildFromGit(gitRepo, null, null);
    }

    protected void deployBuildFromGit(String gitRepo, String branch, String contextDir) {
        BuildConfigBuilder bcb = this.getPreconfiguredBuildConfig();
        BuildConfig bc = bcb.gitSource(gitRepo).gitRef(branch).gitContextDir(contextDir).build();
        this.deployResources(bc);
        this.startBuild(bc);
    }

    protected void deployResources(BuildConfig bc) {
        ImageStream is = new ImageStreamBuilder(this.buildName).build();
        this.openshift.createImageStream(is, this.buildNamespace);
        this.openshift.createBuildConfig(bc, this.buildNamespace);
    }

    protected void startBuild(BuildConfig bc) {
        this.openshift.startBuild(bc, this.buildNamespace);
    }

    protected BuildConfigBuilder getPreconfiguredBuildConfig() {
        BuildConfigBuilder bcb = new BuildConfigBuilder(this.buildName);
        SourceBuildStrategy sbs = bcb.setOutput(this.buildName).sti().fromDockerImage(this.definition.getBuilderImage()).forcePull(this.definition.isForcePull());
        if (this.definition.getEnvProperties() != null) {
            this.definition.getEnvProperties().forEach((k, v) -> sbs.addEnvVariable((String)k, (String)v));
        }
        if (TestConfiguration.mavenProxyEnabled()) {
            sbs.addEnvVariable("MAVEN_MIRROR_URL", TestConfiguration.mavenProxyURL());
        }
        return bcb;
    }

    public abstract void deleteBuild();

    protected void deleteOpenshiftResources() {
        BuildConfig bc = this.openshift.getBuildConfig(this.buildName, this.buildNamespace);
        ImageStream is = this.openshift.getImageStream(this.buildName, this.buildNamespace);
        List<Build> builds = this.openshift.getBuilds(this.buildNamespace).stream().filter(b -> b.getMetadata().getLabels().containsValue(this.buildName)).collect(Collectors.toList());
        if (bc != null) {
            log.debug("Deleting bc {}", (Object)bc.getMetadata().getName());
            this.openshift.deleteBuildConfig(bc, this.buildNamespace);
        }
        if (is != null) {
            log.debug("Deleting is {}", (Object)is.getMetadata().getName());
            this.openshift.deleteImageStream(is, this.buildNamespace);
        }
        if (builds != null) {
            builds.forEach(b -> log.debug("Deleting build {}", (Object)b.getMetadata().getName()));
            builds.forEach(b -> this.openshift.deleteBuild((Build)b, this.buildNamespace));
        }
        if (bc != null || is != null || builds != null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public abstract void updateBuild();

    public void waitForCompletion() {
        this.waitForCompletion(20L);
    }

    public void waitForCompletion(long timeout) {
        boolean success = false;
        try {
            success = WaitUtil.waitFor(() -> this.getBuildStatus(), x -> x == BuildStatus.READY, x -> x == BuildStatus.FAILED, 5000L, TimeUnit.MINUTES.toMillis(timeout));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Build " + this.buildName + " run out of time");
        }
        if (!success) {
            throw new IllegalStateException("Build " + this.buildName + " failed");
        }
    }

    public abstract BuildStatus getBuildStatus();

    protected BuildStatus getCommonStatus(BuildConfig bc) {
        if (!this.isBuildConfigPresent()) {
            return BuildStatus.NOT_DEPLOYED;
        }
        if (!this.isImageUpToDate(bc)) {
            return BuildStatus.OLD_IMAGE;
        }
        return this.getLastBuildOpenshiftStatus(bc);
    }

    protected boolean isBuildConfigPresent() {
        return this.getBuildConfig() != null;
    }

    protected boolean isImageUpToDate(BuildConfig bc) {
        return bc.getSpec().getStrategy().getSourceStrategy().getFrom().getName().equals(this.definition.getBuilderImage());
    }

    protected BuildStatus getLastBuildOpenshiftStatus(BuildConfig bc) {
        String phase;
        long version = bc.getStatus().getLastVersion();
        Build build = this.openshift.getBuild(this.buildName + "-" + version, this.buildNamespace);
        if (build != null && (phase = build.getStatus().getPhase()) != null) {
            switch (build.getStatus().getPhase()) {
                case "Failed": {
                    return BuildStatus.FAILED;
                }
                case "Complete": {
                    return BuildStatus.READY;
                }
                case "Running": {
                    return BuildStatus.RUNNING;
                }
                case "Pending": {
                    return BuildStatus.PENDING;
                }
                case "New": {
                    return BuildStatus.NEW;
                }
            }
            return BuildStatus.DEPLOYED;
        }
        return BuildStatus.NOT_DEPLOYED;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public static enum BuildStatus {
        NOT_DEPLOYED,
        NEW,
        RUNNING,
        PENDING,
        DEPLOYED,
        READY,
        FAILED,
        OLD_IMAGE,
        SOURCE_CHANGE,
        GIT_REPO_GONE,
        ERROR;

    }
}

