/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.git;

import cz.xtf.TestConfiguration;
import cz.xtf.git.GitProject;
import cz.xtf.git.GitUtil;
import cz.xtf.git.PomModifier;
import cz.xtf.io.IOUtils;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.util.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Fail;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLabUtil {
    private static final String SEPARATOR = "------";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabUtil.class);
    private final GitlabAPI api;
    private String gitRepoSshUrl = null;
    private String gitRepoHttpUrl = null;
    private Path gitRepoLocalPath = null;
    private static final int WAIT_FOR_GITLAB_CREATE_PROJECT_MAX_ATTEMPTS = 5;
    private static final int WAIT_FOR_GITLAB_CREATE_PROJECT_TIME = 10000;
    private static final String WAIT_FOR_GITLAB_CREATE_PROJECT_MESSAGE = "Please try again later";

    public GitLabUtil() {
        try {
            this.api = TestConfiguration.dynamicGitLab() ? GitlabAPI.connect((String)TestConfiguration.gitLabURL(), (String)GitlabAPI.connect((String)TestConfiguration.gitLabURL(), (String)TestConfiguration.gitLabUsername(), (String)TestConfiguration.gitLabPassword()).getPrivateToken()) : GitlabAPI.connect((String)TestConfiguration.gitLabURL(), (String)TestConfiguration.gitLabToken());
        }
        catch (IOException e) {
            LOGGER.error("Error while connecting to GitLab", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public String getProjectUrl(String projectName) {
        Optional<GitlabProject> project = this.getProjects(this.getGroupId()).filter(p -> p.getName().equals(projectName) | p.getName().startsWith(projectName)).findFirst();
        if (!project.isPresent() && this.getGroupId() != this.getGroupId(TestConfiguration.gitLabGroup())) {
            LOGGER.debug("Couldn't find project {} in assigned group", (Object)projectName);
            project = this.getProjects(this.getGroupId(TestConfiguration.gitLabGroup())).filter(p -> p.getName().equals(projectName)).findFirst();
        }
        if (!project.isPresent()) {
            throw new IllegalArgumentException("Project '" + projectName + "' was not found");
        }
        return project.get().getHttpUrl();
    }

    public GitProject createProject() {
        return this.createProject(null);
    }

    public GitProject createProject(String name) {
        this.initGitLabProject(name, null);
        return this.createAndInitGitLabProject();
    }

    public GitProject createAndInitGitLabProject() {
        GitProject project = TestConfiguration.dynamicGitLab() ? GitUtil.initRepository(this.gitRepoLocalPath, this.gitRepoHttpUrl, TestConfiguration.gitLabUsername(), TestConfiguration.gitLabPassword()) : GitUtil.initRepository(this.gitRepoLocalPath, this.gitRepoSshUrl);
        project.setHttpUrl(this.gitRepoHttpUrl);
        return project;
    }

    public GitProject createProjectFromPath(String path) {
        return this.createProjectFromPath(null, path);
    }

    public GitProject createProjectFromPath(String name, String path) {
        return this.createProjectFromPath(name, Paths.get(path, new String[0]));
    }

    public GitProject createProjectFromPath(String name, Path path) {
        return this.createProjectFromPathWithMavenProfile(name, path, null);
    }

    public GitProject createProjectFromPathWithMavenProfile(String name, Path path, String mavenProfile) {
        return this.createProject(name, path, mavenProfile, null);
    }

    public GitProject createProject(String name, Path path, String mavenProfile, Consumer<GitProject> injectFiles) {
        return this.createProject(name, path, mavenProfile, injectFiles, true);
    }

    public GitProject createProject(String name, Path path, String mavenProfile, Consumer<GitProject> injectFiles, boolean modifyPom) {
        this.initGitLabProject(name, null);
        Path sourcePath = path.toAbsolutePath();
        try {
            IOUtils.copy(sourcePath, this.gitRepoLocalPath);
        }
        catch (IOException e) {
            LOGGER.error("Error when copying files to the local repository", (Throwable)e);
            return null;
        }
        if (modifyPom) {
            PomModifier pom = new PomModifier(sourcePath, this.gitRepoLocalPath);
            pom.modify();
        }
        GitProject project = this.createAndInitGitLabProject();
        if (mavenProfile != null) {
            project.addProfileToSTIBuild(mavenProfile);
        }
        if (injectFiles != null) {
            injectFiles.accept(project);
        }
        project.addAll();
        project.commit("initial commit");
        project.push();
        LOGGER.debug("Project \"" + name + "\" was created");
        return project;
    }

    private void initGitLabProject(String name, String url) {
        name = name == null || name.length() == 0 ? UUID.randomUUID().toString() : RandomUtil.generateUniqueId(name, SEPARATOR);
        try {
            GitlabProject project = null;
            IOException lastExcepion = null;
            for (int attempt = 0; project == null && attempt < 5; ++attempt) {
                try {
                    project = this.api.createProject(name, this.getGroupId(), null, null, null, null, null, null, Boolean.valueOf(true), null, url);
                    continue;
                }
                catch (IOException x) {
                    lastExcepion = x;
                    if (!x.getMessage().contains(WAIT_FOR_GITLAB_CREATE_PROJECT_MESSAGE) || attempt >= 5) {
                        throw x;
                    }
                    LOGGER.debug("Error when creating project in GitLab. Attempt " + attempt + " of " + 5, (Throwable)x);
                    try {
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw x;
                    }
                }
            }
            if (project == null) {
                Fail.fail((String)"Failed to create git repository", lastExcepion);
            } else {
                this.gitRepoHttpUrl = project.getHttpUrl();
                this.gitRepoSshUrl = project.getSshUrl();
                this.gitRepoLocalPath = this.pathToProject(name);
                if (Files.notExists(this.gitRepoLocalPath, new LinkOption[0])) {
                    Files.createDirectories(this.gitRepoLocalPath, new FileAttribute[0]);
                } else {
                    FileUtils.deleteDirectory((File)this.gitRepoLocalPath.toFile());
                    Files.createDirectories(this.gitRepoLocalPath, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error when creating project in GitLab", (Throwable)e);
        }
    }

    public boolean deleteAllProjects() {
        LOGGER.debug("Deleting all projects in this namespace.");
        return this.getProjects(this.getGroupId()).map(p -> this.deleteProject(p.getName())).reduce(true, (b1, b2) -> b1 != false && b2 != false);
    }

    public boolean deleteProject(String name) {
        return this.getProjects(this.getGroupId()).filter(p -> p.getName().equals(name) || p.getName().startsWith(name + SEPARATOR)).map(project -> {
            try {
                this.performDeleteProject(project.getId());
                IOUtils.deleteDirectory(this.pathToProject(project.getName()));
                LOGGER.debug("Project \"" + name + "\" was deleted");
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("Can not instantiate value of type [simple type, class java.lang.Void]")) {
                    LOGGER.debug("Project \"" + name + "\" was deleted");
                    LOGGER.trace("Catch known exception when deleting project in GitLab", (Throwable)e);
                }
                LOGGER.error("Error when deleting project in GitLab", (Throwable)e);
                return false;
            }
            return true;
        }).anyMatch(x -> x == false);
    }

    private void performDeleteProject(Serializable projectId) throws IOException {
        this.api.deleteProject(projectId);
    }

    private Integer getGroupId() {
        String namespace = OpenshiftUtil.getInstance().getContext().getNamespace();
        String groupName = namespace != null && namespace.endsWith("-automated") ? namespace : TestConfiguration.gitLabGroup();
        return this.getGroupId(groupName);
    }

    private Integer getGroupId(String groupName) {
        try {
            List groups = this.api.getGroups();
            for (GitlabGroup group : groups) {
                if (!group.getName().equals(groupName)) continue;
                return group.getId();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Stream<GitlabProject> getProjects(Integer inGroup) {
        try {
            return this.api.getProjects().stream().filter(p -> p.getNamespace().getId().equals(inGroup));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to list projects", e);
        }
    }

    private Path pathToProject(String projectName) {
        return GitUtil.REPOSITORIES.resolve(projectName);
    }
}

