/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public class IOUtils {
    public static final Path TMP_DIRECTORY = Paths.get("tmp", new String[0]).toAbsolutePath();
    public static final Path LOG_DIRECTORY = Paths.get("log", new String[0]).toAbsolutePath();

    private IOUtils() {
    }

    public static void copy(InputStream src, OutputStream dest) throws IOException {
        try (ReadableByteChannel srcChannel = Channels.newChannel(src);
             WritableByteChannel destChannel = Channels.newChannel(dest);){
            IOUtils.copy(srcChannel, destChannel);
        }
    }

    public static void copy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        dest.write(buffer);
    }

    public static String readInputStream(InputStream input) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public static Collection<String> readInputStreamAsCollection(InputStream input) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    public static Path findProjectRoot() {
        Path dir = Paths.get("", new String[0]).toAbsolutePath();
        while (dir.getParent().resolve("pom.xml").toFile().exists()) {
            dir = dir.getParent();
        }
        return dir;
    }

    public static void copy(Path source, Path target) throws IOException {
        if (Files.isDirectory(target, new LinkOption[0])) {
            if (Files.isDirectory(source, new LinkOption[0])) {
                if (Files.notExists(target, new LinkOption[0])) {
                    Files.walkFileTree(source, new CopyFilesWalker(target));
                } else {
                    Files.walkFileTree(source, new CopyFilesWalker(target, true));
                }
            } else {
                Files.copy(source, target.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            if (Files.isDirectory(source, new LinkOption[0])) {
                throw new IOException("Can't copy directory into file");
            }
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static <T> boolean waitForCondition(int retries, long sleep, T baseObject, Function<T, T> valueProducer, Function<T, Boolean> condition) {
        return IOUtils.waitForCondition(retries, sleep, baseObject, valueProducer, condition, ex -> LoggerFactory.getLogger(IOUtils.class).warn("Error during waitForCondition", (Throwable)ex));
    }

    public static <T> boolean waitForCondition(int retries, long sleep, T baseObject, Function<T, T> valueProducer, Function<T, Boolean> condition, Consumer<Exception> exceptionHandler) {
        int counter = retries;
        T value = baseObject;
        do {
            block3: {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ex) {
                    if (exceptionHandler == null) break block3;
                    exceptionHandler.accept(ex);
                }
            }
            value = valueProducer.apply(value);
        } while (counter-- > 0 && value != null && condition.apply(value).booleanValue());
        return value == null || condition.apply(valueProducer.apply(value)) != false;
    }

    public static void deleteDirectory(Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.delete(directory);
        }
    }

    private static class CopyFilesWalker
    extends SimpleFileVisitor<Path> {
        private Path target;
        private boolean skipFirstDir;

        public CopyFilesWalker(Path target) {
            this(target, false);
        }

        public CopyFilesWalker(Path target, boolean skipFirstDir) {
            this.target = target;
            this.skipFirstDir = skipFirstDir;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.skipFirstDir) {
                this.skipFirstDir = false;
            } else {
                if (dir.toAbsolutePath().normalize().equals(TMP_DIRECTORY.toAbsolutePath().normalize()) || dir.endsWith(".git")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                this.target = this.target.resolve(dir.getFileName());
                if (!Files.exists(this.target, new LinkOption[0])) {
                    Files.createDirectory(this.target, new FileAttribute[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.target.resolve(file.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.target = this.target.getParent();
            return FileVisitResult.CONTINUE;
        }
    }
}

