/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit;

import cz.xtf.junit.annotation.KnownIssue;
import cz.xtf.junit.annotation.release.SinceVersion;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntermediateReporter
extends RunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateReporter.class);
    private final Document xml;
    private final Path reportPath;
    private final boolean working;
    private final AtomicInteger tests = new AtomicInteger(0);
    private final AtomicInteger errors = new AtomicInteger(0);
    private final AtomicInteger failures = new AtomicInteger(0);
    private final AtomicInteger ignored = new AtomicInteger(0);
    private final AtomicLong suiteStartTime = new AtomicLong(0L);
    private final AtomicReference<Element> testsuite = new AtomicReference();
    private final Map<String, Long> testTimes = new HashMap<String, Long>();

    public IntermediateReporter() {
        boolean working = true;
        Document xml = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            xml = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Failed to create XML DOM, reporting will not be provided", (Throwable)ex);
            working = false;
        }
        Path reportPath = null;
        try {
            reportPath = Paths.get("log", "junit-report.xml").toAbsolutePath().normalize();
            Files.createFile(reportPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to create destination file, reporting will not be provided", (Throwable)ex);
            working = false;
        }
        this.working = working;
        this.xml = xml;
        this.reportPath = reportPath;
    }

    public void testRunStarted(Description description) throws Exception {
        if (this.working) {
            this.suiteStartTime.set(System.currentTimeMillis());
            Element testsuite = this.xml.createElement("testsuite");
            if (description.getChildren().size() == 1) {
                testsuite.setAttribute("name", this.safeString(((Description)description.getChildren().get(0)).getDisplayName()));
            }
            this.xml.appendChild(testsuite);
            this.testsuite.set(testsuite);
            this.writeXml();
        }
    }

    public void testStarted(Description description) throws Exception {
        if (this.working) {
            this.testTimes.put(description.getDisplayName(), System.currentTimeMillis());
        }
    }

    public void testFinished(Description description) throws Exception {
        if (this.working && this.testTimes.containsKey(description.getDisplayName())) {
            this.testsuite.get().appendChild(this.createTestCase(description));
            this.writeXml();
        }
    }

    public void testAssumptionFailure(Failure failure) {
        if (this.working) {
            this.ignored.incrementAndGet();
            Element testcase = this.createTestCase(failure.getDescription());
            Element skipped = this.xml.createElement("skipped");
            skipped.setAttribute("message", this.safeString(failure.getMessage()));
            testcase.appendChild(skipped);
            this.testsuite.get().appendChild(testcase);
            this.writeXml();
        }
    }

    private boolean isKnownIssue(Failure failure) {
        if (failure == null) {
            return false;
        }
        if (failure.getDescription() == null) {
            return false;
        }
        KnownIssue knownIssue = (KnownIssue)failure.getDescription().getAnnotation(KnownIssue.class);
        String message = failure.getMessage();
        if (knownIssue == null || message == null || knownIssue.value() == null) {
            return false;
        }
        return message.contains(knownIssue.value());
    }

    private boolean isSinceVersion(Failure failure) {
        return failure.getDescription().getAnnotation(SinceVersion.class) != null;
    }

    private String prependSinceVersionJira(Failure failure, String message) {
        for (Annotation ann : failure.getDescription().getAnnotations()) {
            SinceVersion sv;
            if (ann.annotationType() != SinceVersion.class || (sv = (SinceVersion)ann).jira().isEmpty()) continue;
            return "@SinceVersion " + sv.jira() + "\n" + message;
        }
        return message;
    }

    public void testFailure(Failure failure) throws Exception {
        if (this.working) {
            if (failure.getDescription().getMethodName() == null) {
                for (Description child : failure.getDescription().getChildren()) {
                    this.testFailure(new Failure(child, failure.getException()));
                }
            } else {
                Element element;
                Element testcase = this.createTestCase(failure.getDescription());
                if (failure.getException() instanceof AssertionError) {
                    if (this.isKnownIssue(failure)) {
                        this.ignored.incrementAndGet();
                        element = this.xml.createElement("skipped");
                    } else {
                        this.failures.incrementAndGet();
                        element = this.xml.createElement("failure");
                    }
                } else {
                    this.errors.incrementAndGet();
                    element = this.xml.createElement("error");
                }
                testcase.appendChild(element);
                String message = this.isSinceVersion(failure) ? this.prependSinceVersionJira(failure, failure.getMessage()) : failure.getMessage();
                element.setAttribute("type", this.safeString(failure.getException().getClass().getName()));
                element.setAttribute("message", this.safeString(message));
                element.appendChild(this.xml.createCDATASection(this.safeString(failure.getTrace())));
                this.testsuite.get().appendChild(testcase);
                this.writeXml();
            }
        }
    }

    public void testIgnored(Description description) throws Exception {
        if (this.working) {
            this.ignored.incrementAndGet();
            Element testcase = this.createTestCase(description);
            Element skipped = this.xml.createElement("skipped");
            skipped.setAttribute("message", this.safeString(((Ignore)description.getAnnotation(Ignore.class)).value()));
            testcase.appendChild(skipped);
            this.testsuite.get().appendChild(testcase);
            this.writeXml();
        }
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.working) {
            this.writeXml();
        }
    }

    private void writeXml() {
        Element testsuite = this.testsuite.get();
        testsuite.setAttribute("tests", Integer.toString(this.tests.get()));
        testsuite.setAttribute("errors", Integer.toString(this.errors.get()));
        testsuite.setAttribute("skipped", Integer.toString(this.ignored.get()));
        testsuite.setAttribute("failures", Integer.toString(this.failures.get()));
        testsuite.setAttribute("time", this.computeTestTime(this.suiteStartTime.get()));
        try (BufferedWriter writer = Files.newBufferedWriter(this.reportPath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING);){
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(this.xml), new StreamResult(writer));
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Misconfigured transformer", (Throwable)ex);
        }
        catch (TransformerException ex) {
            LOGGER.error("Unable to save XML file", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to open report file", (Throwable)ex);
        }
    }

    private String computeTestTime(Long startTime) {
        if (startTime == null) {
            return "0";
        }
        long amount = System.currentTimeMillis() - startTime;
        return String.format("%.3f", Float.valueOf((float)amount / 1000.0f));
    }

    private Element createTestCase(Description description) {
        this.tests.incrementAndGet();
        Element testcase = this.xml.createElement("testcase");
        testcase.setAttribute("name", this.safeString(description.getMethodName()));
        testcase.setAttribute("classname", this.safeString(description.getClassName()));
        testcase.setAttribute("time", this.computeTestTime(this.testTimes.remove(description.getDisplayName())));
        return testcase;
    }

    private String safeString(String input) {
        if (input == null) {
            return "null";
        }
        return input.replaceAll("\u001b\\[\\d+m", "").replaceAll("[\\p{Cntrl}&&[^\\p{Space}]]", "");
    }
}

