/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit;

import cz.xtf.build.BuildManagerV2;
import cz.xtf.build.XTFBuild;
import cz.xtf.junit.SuiteUtils;
import cz.xtf.junit.XTFTestSuiteHelper;
import cz.xtf.junit.annotation.PrepareProject;
import cz.xtf.junit.annotation.RecordImageUsage;
import cz.xtf.junit.annotation.UsesBuild;
import cz.xtf.manipulation.ImageStreamProcessor;
import cz.xtf.manipulation.LogCleaner;
import cz.xtf.manipulation.ProjectHandler;
import cz.xtf.manipulation.Recorder;
import cz.xtf.openshift.imagestream.ImageStreamRequest;
import cz.xtf.util.WaitingUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.NonNull;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XTFTestSuite
extends ParentRunner<Runner> {
    private static final Logger log = LoggerFactory.getLogger(XTFTestSuite.class);
    private static final Object $LOCK = new Object[0];
    public static final String DEFAULT_TEST_SUFFIX = "Test";
    private static final Map<Class<?>, List<Runner>> RUNNERS_CACHE = new HashMap();
    private static final Map<Class<?>, List<Class<?>>> TEST_CLASSES_CACHE = new HashMap();
    private static Class<?> suiteClass;
    private static ProjectHandler projectHandler;
    private final List<Runner> testRunners;

    public XTFTestSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(suiteClass);
        XTFTestSuite.suiteClass = suiteClass;
        this.testRunners = XTFTestSuite.getRunners(suiteClass, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Runner> getRunners(@NonNull Class<?> suiteClass, @NonNull RunnerBuilder builder) throws InitializationError {
        Object object = $LOCK;
        synchronized (object) {
            if (suiteClass == null) {
                throw new NullPointerException("suiteClass");
            }
            if (builder == null) {
                throw new NullPointerException("builder");
            }
            List<Object> runners = RUNNERS_CACHE.get(suiteClass);
            if (runners == null) {
                List<Class<?>> testClasses = XTFTestSuite.resolveTestClasses(suiteClass);
                runners = Collections.unmodifiableList(builder.runners(suiteClass, testClasses));
                RUNNERS_CACHE.put(suiteClass, runners);
                TEST_CLASSES_CACHE.put(suiteClass, testClasses);
            }
            return runners;
        }
    }

    private static List<Class<?>> resolveTestClasses(Class<?> suiteClass) throws InitializationError {
        try {
            log.info("action=resolving-test-classes status=START suite={}", suiteClass);
            List<Class<?>> classes = new XTFTestSuiteHelper(suiteClass).resolveTestClasses();
            log.info("action=resolving-test-classes status=START suite={} testClasses={}", suiteClass, (Object)classes.size());
            log.debug("Test classes:", (Object)classes.size());
            classes.forEach(c -> log.debug(" - {}", (Object)c.getName()));
            return classes;
        }
        catch (IOException | URISyntaxException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    public static void beforeSuite() throws Exception {
        Recorder.recordEnvironmentVersions();
        LogCleaner.cleanAllLogDirectories();
        XTFTestSuite.prepareProject();
        XTFTestSuite.recordUsedImages();
        XTFTestSuite.createImageStreams();
        XTFTestSuite.deployBuilds();
    }

    public static void afterSuite() throws Exception {
        XTFTestSuite.cleanProject();
        Recorder.storeTestConfiguration();
    }

    private static List<FrameworkMethod> join(@NonNull FrameworkMethod fm, @NonNull List<FrameworkMethod> methods, boolean asFirst) {
        if (fm == null) {
            throw new NullPointerException("fm");
        }
        if (methods == null) {
            throw new NullPointerException("methods");
        }
        ArrayList<FrameworkMethod> joined = new ArrayList<FrameworkMethod>(methods.size() + 1);
        if (asFirst) {
            joined.add(fm);
            joined.addAll(methods);
        } else {
            joined.addAll(methods);
            joined.add(fm);
        }
        return joined;
    }

    private static void prepareProject() {
        PrepareProject prepareProject = suiteClass.getAnnotation(PrepareProject.class);
        if (prepareProject != null) {
            projectHandler = new ProjectHandler(prepareProject.value());
            projectHandler.prepare();
        }
    }

    private static void recordUsedImages() {
        RecordImageUsage recordImageUsage = suiteClass.getAnnotation(RecordImageUsage.class);
        if (recordImageUsage != null) {
            Recorder.recordUsedImages(recordImageUsage.value());
        }
    }

    private static void createImageStreams() {
        List<Class<?>> tcs = TEST_CLASSES_CACHE.get(suiteClass);
        Set<ImageStreamRequest> requests = SuiteUtils.getImageStreamRequests(suiteClass, tcs);
        if (requests.size() > 0) {
            requests.forEach(r -> ImageStreamProcessor.createImageStream(r));
            WaitingUtils.waitSilently("wait-for-ImageStreams");
        }
    }

    private static void deployBuilds() {
        HashSet buildsToBeBuild = new HashSet();
        TEST_CLASSES_CACHE.forEach((k, v) -> v.forEach(c -> Arrays.stream(c.getAnnotations()).filter(a -> a.annotationType().getAnnotation(UsesBuild.class) != null).forEach(a -> {
            try {
                Object result = a.annotationType().getMethod("value", new Class[0]).invoke(a, new Object[0]);
                if (result instanceof XTFBuild) {
                    buildsToBeBuild.add(((XTFBuild)result).getBuildDefinition());
                } else if (result instanceof XTFBuild[]) {
                    Stream.of((XTFBuild[])result).forEach(x -> buildsToBeBuild.add(x.getBuildDefinition()));
                } else {
                    log.error("Value present in {} is not instance of {}, not able to get BuildDefinition to be built");
                }
            }
            catch (Exception e) {
                log.error("Failed to invoke value() on annotation " + a.annotationType().getName(), (Throwable)e);
            }
        })));
        BuildManagerV2.get().deployBuilds(buildsToBeBuild);
    }

    private static void cleanProject() {
        if (projectHandler != null) {
            projectHandler.saveEventsLog();
            projectHandler.cleanup();
        }
    }

    protected List<Runner> getChildren() {
        return this.testRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        runner.run(notifier);
    }

    protected Statement withBeforeClasses(Statement statement) {
        FrameworkMethod fm = new FrameworkMethod(XTFTestSuite.class.getDeclaredMethod("beforeSuite", new Class[0]));
        return new RunBefores(statement, XTFTestSuite.join(fm, this.getTestClass().getAnnotatedMethods(BeforeClass.class), true), null);
    }

    protected Statement withAfterClasses(Statement statement) {
        FrameworkMethod fm = new FrameworkMethod(XTFTestSuite.class.getDeclaredMethod("afterSuite", new Class[0]));
        return new RunAfters(statement, XTFTestSuite.join(fm, this.getTestClass().getAnnotatedMethods(AfterClass.class), false), null);
    }
}

