/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.maven;

import cz.xtf.TestConfiguration;
import cz.xtf.http.HttpUtil;
import cz.xtf.openshift.OpenshiftUtil;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.maven.it.VerificationException;
import org.apache.maven.it.Verifier;

public class MavenUtil {
    private final Verifier maven;

    private MavenUtil(Verifier maven) {
        this.maven = maven;
        maven.setForkJvm(false);
    }

    public static MavenUtil forProject(Path projectPath) throws VerificationException {
        Verifier verifier = new Verifier(projectPath.toAbsolutePath().toString());
        return new MavenUtil(verifier);
    }

    public static MavenUtil forProject(Path projectPath, Path settingsXmlPath) throws VerificationException {
        Verifier verifier = new Verifier(projectPath.toAbsolutePath().toString(), settingsXmlPath.toAbsolutePath().toString());
        MavenUtil result = new MavenUtil(verifier);
        result.useSettingsXml(settingsXmlPath);
        return result;
    }

    public MavenUtil useSettingsXml(Path settingsXmlPath) {
        this.maven.addCliOption("-s " + settingsXmlPath.toAbsolutePath().toString());
        return this;
    }

    public MavenUtil disableAutoclean() {
        this.maven.setAutoclean(false);
        return this;
    }

    public MavenUtil forkJvm() {
        this.maven.setForkJvm(true);
        if (System.getProperty("sun.net.spi.nameservice.nameservers") != null) {
            this.maven.setSystemProperty("sun.net.spi.nameservice.nameservers", System.getProperty("sun.net.spi.nameservice.nameservers"));
            this.maven.setSystemProperty("sun.net.spi.nameservice.provider.1", "dns,sun");
            this.maven.setSystemProperty("sun.net.spi.nameservice.provider.2", "default");
        }
        return this;
    }

    public MavenUtil deployToSnapshots() {
        return this.deployToRepository("maven", TestConfiguration.mavenDeploySnapshotURL());
    }

    public MavenUtil deployToRelease() {
        return this.deployToRepository("maven", TestConfiguration.mavenDeployReleaseURL());
    }

    public MavenUtil deployToRepository(String name, String repository) {
        this.maven.setSystemProperty("altDeploymentRepository", String.format("%s::default::%s", name, repository));
        return this;
    }

    public void executeGoals(String ... goals) throws VerificationException {
        try {
            this.maven.executeGoals(Arrays.asList(goals));
        }
        finally {
            this.maven.resetStreams();
        }
    }

    public MavenUtil addCliOptions(List<String> options) {
        options.stream().forEach(arg_0 -> ((Verifier)this.maven).addCliOption(arg_0));
        return this;
    }

    public MavenUtil addCliOptions(String ... options) {
        this.addCliOptions(Arrays.asList(options));
        return this;
    }

    public MavenUtil setEnvironmentVariable(String key, String value) {
        this.maven.setEnvironmentVariable(key, value);
        return this;
    }

    public static boolean checkRepositoryAvailability() {
        Optional<Route> routeOptional = OpenshiftUtil.getInstance().withAdminUser(x -> ((RouteList)((ClientNonNamespaceOperation)x.routes().inNamespace("test-infra")).list()).getItems()).stream().filter(r -> r.getSpec().getHost().startsWith("maven")).findAny();
        if (routeOptional.isPresent()) {
            try {
                HttpUtil.httpGet("http://" + routeOptional.get().getSpec().getHost());
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

