/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceAccountBuilder
extends AbstractBuilder<ServiceAccount, ServiceAccountBuilder> {
    private final List<String> secrets = new LinkedList<String>();

    public ServiceAccountBuilder(String name) {
        this(null, name);
    }

    ServiceAccountBuilder(ApplicationBuilder applicationBuilder, String name) {
        super(applicationBuilder, name);
    }

    public ServiceAccountBuilder addSecret(String name) {
        this.secrets.add(name);
        return this;
    }

    public ServiceAccountBuilder addSecret(Secret secret) {
        this.secrets.add(secret.getMetadata().getName());
        return this;
    }

    @Override
    public ServiceAccount build() {
        return ((io.fabric8.kubernetes.api.model.ServiceAccountBuilder)((io.fabric8.kubernetes.api.model.ServiceAccountBuilder)new io.fabric8.kubernetes.api.model.ServiceAccountBuilder().withMetadata(this.metadataBuilder().build())).withSecrets(this.secrets.stream().map(secret -> ((ObjectReferenceBuilder)new ObjectReferenceBuilder().withName(secret)).build()).collect(Collectors.toList()))).build();
    }

    @Override
    protected ServiceAccountBuilder getThis() {
        return this;
    }
}

