/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.db;

import cz.xtf.openshift.PodService;
import cz.xtf.openshift.builder.pod.PersistentVolumeClaim;
import cz.xtf.openshift.db.AbstractDatabase;
import cz.xtf.openshift.db.SQLExecutor;
import cz.xtf.openshift.db.SQLExecutorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public abstract class AbstractSQLDatabase
extends AbstractDatabase
implements SQLExecutor {
    public AbstractSQLDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        super(symbolicName, dataDir, withLivenessProbe, withReadinessProbe, configureEnvironment);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, boolean configureEnvironment) {
        super(username, password, dbName, symbolicName, dataDir, withLivenessProbe, withReadinessProbe, configureEnvironment);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(symbolicName, dataDir, pvc, withLivenessProbe, withReadinessProbe);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(symbolicName, dataDir, pvc);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir, PersistentVolumeClaim pvc) {
        super(username, password, dbName, symbolicName, dataDir, pvc);
    }

    public AbstractSQLDatabase(String username, String password, String dbName, String symbolicName, String dataDir) {
        super(username, password, dbName, symbolicName, dataDir);
    }

    public AbstractSQLDatabase(String symbolicName, String dataDir) {
        super(symbolicName, dataDir);
    }

    public SQLExecutor getSQLExecutor(String hostname, int port) {
        return new SQLExecutorImpl(String.format(this.getJDBCConnectionStringPattern(), hostname, port, this.getDbName()), this.getUsername(), this.getPassword());
    }

    @Override
    public void executeSQL(Consumer<Connection> execute) {
        try (PodService pod = new PodService(this.getPod());){
            this.getSQLExecutor("localhost", pod.portForward(this.getPort())).executeSQL(execute);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void executeSQLFile(String resourceName) {
        this.executeSQL(db -> {
            try {
                IOUtils.readLines((InputStream)AbstractSQLDatabase.class.getResourceAsStream(resourceName)).forEach(x -> {
                    try {
                        db.createStatement().execute((String)x);
                    }
                    catch (SQLException e) {
                        throw new IllegalArgumentException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected abstract String getJDBCConnectionStringPattern();
}

