/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.imagestream;

import cz.xtf.openshift.imagestream.ImageRegistry;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class ImageStreamRequest {
    @NonNull
    private final String name;
    @NonNull
    private final String imageName;
    private final List<String> tags;

    public String getImage() {
        if (this.imageName.contains("/")) {
            return this.imageName;
        }
        try {
            return (String)ImageRegistry.class.getDeclaredMethod(this.imageName, new Class[0]).invoke((Object)ImageRegistry.get(), new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(String.format("Cannot retrieve image '%s' from registry", this.imageName), e);
        }
    }

    public static ImageStreamRequestBuilder builder() {
        return new ImageStreamRequestBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getImageName() {
        return this.imageName;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "ImageStreamRequest(name=" + this.getName() + ", imageName=" + this.getImageName() + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"name", "imageName", "tags"})
    public ImageStreamRequest(@NonNull String name, @NonNull String imageName, List<String> tags) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (imageName == null) {
            throw new NullPointerException("imageName");
        }
        this.name = name;
        this.imageName = imageName;
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageStreamRequest)) {
            return false;
        }
        ImageStreamRequest other = (ImageStreamRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public static class ImageStreamRequestBuilder {
        private String name;
        private String imageName;
        private ArrayList<String> tags;

        ImageStreamRequestBuilder() {
        }

        public ImageStreamRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ImageStreamRequestBuilder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public ImageStreamRequestBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public ImageStreamRequestBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public ImageStreamRequestBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public ImageStreamRequest build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new ImageStreamRequest(this.name, this.imageName, tags);
        }

        public String toString() {
            return "ImageStreamRequest.ImageStreamRequestBuilder(name=" + this.name + ", imageName=" + this.imageName + ", tags=" + this.tags + ")";
        }
    }
}

