/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.logs;

import cz.xtf.docker.DockerContainer;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.logs.LogCleaner;
import cz.xtf.tuple.Tuple;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCheckerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCheckerUtils.class);

    public static boolean[] findPatternsInLogs(Pod pod, Pattern ... patterns) throws IOException {
        boolean[] found = new boolean[patterns.length];
        StringReader stringReader = new StringReader(OpenshiftUtil.getInstance().getRuntimeLog(pod));
        try (BufferedReader br = new BufferedReader(stringReader);){
            br.lines().forEach(line -> {
                for (int i = 0; i < patterns.length; ++i) {
                    Pattern pattern = patterns[i];
                    if (!pattern.matcher((CharSequence)line).find()) continue;
                    LOGGER.info("Found pattern {} on line '{}'", (Object)pattern, (Object)LogCleaner.cleanLine(line));
                    found[i] = true;
                }
            });
        }
        return found;
    }

    public static boolean[] findPatternsInLogs(DockerContainer dockerContainer, Pattern ... patterns) throws IOException {
        boolean[] found = new boolean[patterns.length];
        dockerContainer.dockerLogs(istream -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(istream, "UTF-8"));){
                br.lines().forEach(line -> {
                    for (int i = 0; i < patterns.length; ++i) {
                        Pattern pattern = patterns[i];
                        if (!pattern.matcher((CharSequence)line).find()) continue;
                        LOGGER.info("Found pattern {} on line '{}'", (Object)pattern, (Object)LogCleaner.cleanLine(line));
                        found[i] = true;
                    }
                });
            }
        });
        return found;
    }

    public static String[] getLinesWithFoundPatternsInLogs(Pod pod, Pattern ... patterns) throws IOException {
        String[] found = new String[patterns.length];
        StringReader stringReader = new StringReader(OpenshiftUtil.getInstance().getRuntimeLog(pod));
        try (BufferedReader br = new BufferedReader(stringReader);){
            br.lines().forEach(line -> {
                for (int i = 0; i < patterns.length; ++i) {
                    Pattern pattern = patterns[i];
                    if (!pattern.matcher((CharSequence)line).find()) continue;
                    LOGGER.info("Found pattern {} on line '{}'", (Object)pattern, (Object)LogCleaner.cleanLine(line));
                    found[i] = line;
                }
            });
        }
        return found;
    }

    private static boolean[] vectorOr(boolean[] b1, boolean[] b2) {
        if (b1 == null && b2 != null) {
            return b2;
        }
        if (b2 == null && b1 != null) {
            return b1;
        }
        assert (b1 != null);
        assert (b2 != null);
        assert (b1.length == b2.length);
        boolean[] found = new boolean[b1.length];
        for (int i = 0; i < found.length; ++i) {
            found[i] = b1[i] || b2[i];
        }
        return found;
    }

    public static boolean[] findPatternsInLogs(Collection<Pod> pods, Pattern ... patterns) throws IOException {
        AtomicReference<Object> foundRef = new AtomicReference<Object>(null);
        pods.forEach(pod -> {
            try {
                foundRef.set(LogCheckerUtils.vectorOr((boolean[])foundRef.get(), LogCheckerUtils.findPatternsInLogs(pod, patterns)));
            }
            catch (Exception x) {
                LOGGER.error("Failed to get logs for pod {}", pod.getMetadata().getLabels().get("name"), (Object)x);
            }
        });
        return foundRef.get();
    }

    static Collection<Pod> defaultPods(String containerName) {
        return OpenshiftUtil.getInstance().findNamedPods(containerName);
    }

    private static String formatPodLists(Collection<Pod> pods) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Pod pod : pods) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(pod.getMetadata().getName());
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean[] findPatternsInLogs(String appName, Pattern ... patterns) throws IOException {
        return LogCheckerUtils.findPatternsInLogs(LogCheckerUtils.defaultPods(appName), patterns);
    }

    public static void assertLogsContains(DockerContainer dockerContainer, String ... strings) throws IOException {
        Pattern[] patterns = new Pattern[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            patterns[i] = Pattern.compile(strings[i]);
        }
        boolean[] found = LogCheckerUtils.findPatternsInLogs(dockerContainer, patterns);
        for (int i = 0; i < patterns.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i]).as("Didn't find pattern '" + patterns[i].toString() + "' in docker container " + dockerContainer.getOpenShiftNode().getHostname() + " " + dockerContainer.getContainerId() + " logs", new Object[0])).isEqualTo(true);
        }
    }

    public static void assertLogsContains(Collection<Pod> pods, String ... strings) throws IOException {
        Pattern[] patterns = new Pattern[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            patterns[i] = Pattern.compile(strings[i]);
        }
        boolean[] found = LogCheckerUtils.findPatternsInLogs(pods, patterns);
        for (int i = 0; i < patterns.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i]).as("Didn't find pattern '" + patterns[i].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + " logs", new Object[0])).isEqualTo(true);
        }
    }

    public static void assertLogsContains(String appName, String ... strings) throws IOException {
        LogCheckerUtils.assertLogsContains(LogCheckerUtils.defaultPods(appName), strings);
    }

    public static void assertLogsContains(String appName, Pattern ... patterns) throws IOException {
        boolean[] found = LogCheckerUtils.findPatternsInLogs(appName, patterns);
        for (int i = 0; i < patterns.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i]).as("Didn't find pattern '" + patterns[i].toString() + "' in pod logs", new Object[0])).isEqualTo(true);
        }
    }

    public static void assertLogsContains(Collection<Pod> pods, Pattern ... patterns) throws IOException {
        boolean[] found = LogCheckerUtils.findPatternsInLogs(pods, patterns);
        for (int i = 0; i < patterns.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i]).as("Didn't find pattern '" + patterns[i].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + " logs", new Object[0])).isEqualTo(true);
        }
    }

    public static void assertLogsContainsOrNot(Collection<Pod> pods, Tuple.Pair<String, String>[] shouldFinds, Tuple.Pair<String, String>[] shouldNotFinds) throws IOException {
        int i;
        Pattern[] patterns = new Pattern[shouldFinds.length + shouldNotFinds.length];
        for (i = 0; i < shouldFinds.length; ++i) {
            patterns[i] = Pattern.compile(shouldFinds[i].getSecond());
        }
        for (i = 0; i < shouldNotFinds.length; ++i) {
            patterns[shouldFinds.length + i] = Pattern.compile(shouldNotFinds[i].getSecond());
        }
        boolean[] found = LogCheckerUtils.findPatternsInLogs(pods, patterns);
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            if (i2 < shouldFinds.length) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i2]).as(shouldFinds[i2].getFirst() + " Didn't find pattern '" + patterns[i2].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + "logs", new Object[0])).isEqualTo(true);
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i2]).as(shouldNotFinds[i2 - shouldFinds.length].getFirst() + " Found pattern '" + patterns[i2].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + "logs", new Object[0])).isEqualTo(false);
        }
    }

    public static void assertLogsContainsOrNot(Collection<Pod> pods, String[] shouldFinds, String[] shouldNotFinds) throws IOException {
        int i;
        Pattern[] patterns = new Pattern[shouldFinds.length + shouldNotFinds.length];
        for (i = 0; i < shouldFinds.length; ++i) {
            patterns[i] = Pattern.compile(shouldFinds[i]);
        }
        for (i = 0; i < shouldNotFinds.length; ++i) {
            patterns[shouldFinds.length + i] = Pattern.compile(shouldNotFinds[i]);
        }
        boolean[] found = LogCheckerUtils.findPatternsInLogs(pods, patterns);
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            if (i2 < shouldFinds.length) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i2]).as("Didn't find pattern '" + patterns[i2].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + "logs", new Object[0])).isEqualTo(true);
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found[i2]).as("Found pattern '" + patterns[i2].toString() + "' in pod " + LogCheckerUtils.formatPodLists(pods) + "logs", new Object[0])).isEqualTo(false);
        }
    }

    public static void assertLogsContainsOrNot(String appName, Tuple.Pair<String, String>[] shouldFinds, Tuple.Pair<String, String>[] shouldNotFinds) throws IOException {
        LogCheckerUtils.assertLogsContainsOrNot(LogCheckerUtils.defaultPods(appName), shouldFinds, shouldNotFinds);
    }

    public static void assertLogsContainsOrNot(String appName, String[] shouldFinds, String[] shouldNotFinds) throws IOException {
        LogCheckerUtils.assertLogsContainsOrNot(LogCheckerUtils.defaultPods(appName), shouldFinds, shouldNotFinds);
    }
}

