/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import java.util.HashMap;
import java.util.Map;

public abstract class BuildDefinition {
    private String name;
    private String appName;
    private String builderImage;
    private Map<String, String> envProperties;
    private boolean forcePull = true;

    protected BuildDefinition(String appName, String builderImage) {
        this(appName, builderImage, new HashMap<String, String>());
    }

    protected BuildDefinition(String appName, String builderImage, Map<String, String> envProperties) {
        this.appName = appName;
        this.builderImage = builderImage;
        this.envProperties = envProperties;
        String[] splitted = this.getBuilderImage().split("/");
        this.name = appName + "-" + splitted[splitted.length - 1].split(":")[0].replace("-openshift", "");
    }

    public String getName() {
        return this.name;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public Map<String, String> getEnvProperties() {
        return this.envProperties;
    }

    public boolean isForcePull() {
        return this.forcePull;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildDefinition)) {
            return false;
        }
        BuildDefinition other = (BuildDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public void setForcePull(boolean forcePull) {
        this.forcePull = forcePull;
    }
}

