/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarUtils.class);

    public static void jar(Path sourceDirectory, Path targetFile) {
        Throwable throwable;
        Path manifestPath = sourceDirectory.resolve("META-INF/MANIFEST.MF");
        Manifest manifest = null;
        if (manifestPath.toFile().exists()) {
            try {
                throwable = null;
                try (FileInputStream manifestIS = new FileInputStream(manifestPath.toFile());){
                    manifest = new Manifest(manifestIS);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error in reading manifest", (Throwable)e);
                throw new IllegalStateException("File was not compressed successfully", e);
            }
        }
        try {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(targetFile.toFile());
                 JarOutputStream jarOutputStream = manifest == null ? new JarOutputStream(fos) : new JarOutputStream((OutputStream)fos, manifest);){
                int sourceDirectoryNameLength = sourceDirectory.toAbsolutePath().toFile().getPath().length() + 1;
                NotFileFilter skipManifest = new NotFileFilter((IOFileFilter)new WildcardFileFilter("MANIFEST.MF"));
                FileUtils.listFiles((File)sourceDirectory.toFile(), (IOFileFilter)skipManifest, (IOFileFilter)TrueFileFilter.TRUE).forEach(file -> {
                    String entryName = file.getPath().substring(sourceDirectoryNameLength);
                    try {
                        jarOutputStream.putNextEntry(new JarEntry(entryName));
                        try (FileInputStream fis = new FileInputStream((File)file);){
                            IOUtils.copy((InputStream)fis, (OutputStream)jarOutputStream);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Error in writing entry", (Throwable)e);
                        throw new IllegalStateException("File was not compressed successfully", e);
                    }
                });
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error in jar", (Throwable)e);
            throw new IllegalStateException("File was not compressed successfully", e);
        }
    }

    public static void unjar(Path targetDirectory, Path sourceFile) {
        try (FileInputStream fis = new FileInputStream(sourceFile.toFile());
             ZipInputStream jarInputStream = new ZipInputStream(fis);){
            byte[] buffer = new byte[65536];
            ZipEntry entry = jarInputStream.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    targetDirectory.resolve(entry.getName()).toFile().mkdirs();
                } else {
                    targetDirectory.resolve(entry.getName()).getParent().toFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(targetDirectory.resolve(entry.getName()).toFile());){
                        int cnt = jarInputStream.read(buffer);
                        while (cnt != -1) {
                            fos.write(buffer, 0, cnt);
                            cnt = jarInputStream.read(buffer);
                        }
                    }
                }
                entry = jarInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error in unjar", (Throwable)e);
            throw new IllegalStateException("File was not uncompressed successfully", e);
        }
    }
}

