/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.junit.filter.ExclusionTestNameFilter;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;

public class ClassNameRegExExclusionFilter
implements ExclusionTestNameFilter {
    public static final String SYSTEM_PROPERTY_INCLUDE = "xtf.test.regex";
    public static final String SYSTEM_PROPERTY_EXCLUDE = "xtf.test.regex.exclude";
    private final Pattern includePattern;
    private final Pattern excludePattern;

    public ClassNameRegExExclusionFilter() {
        String includeString = System.getProperty(SYSTEM_PROPERTY_INCLUDE);
        this.includePattern = includeString == null ? null : Pattern.compile(includeString);
        String excludeString = System.getProperty(SYSTEM_PROPERTY_EXCLUDE);
        this.excludePattern = excludeString == null ? null : Pattern.compile(excludeString);
    }

    @Override
    public boolean exclude(String className) {
        boolean excluded;
        boolean bl = this.includePattern != null ? !this.includePattern.matcher(className).matches() : (excluded = false);
        if (excluded) {
            return true;
        }
        return this.excludePattern != null ? this.excludePattern.matcher(className).matches() : false;
    }

    @ConstructorProperties(value={"includePattern", "excludePattern"})
    public ClassNameRegExExclusionFilter(Pattern includePattern, Pattern excludePattern) {
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
    }

    public String toString() {
        return "ClassNameRegExExclusionFilter(includePattern=" + this.getIncludePattern() + ", excludePattern=" + this.getExcludePattern() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassNameRegExExclusionFilter)) {
            return false;
        }
        ClassNameRegExExclusionFilter other = (ClassNameRegExExclusionFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pattern this$includePattern = this.getIncludePattern();
        Pattern other$includePattern = other.getIncludePattern();
        if (this$includePattern == null ? other$includePattern != null : !this$includePattern.equals(other$includePattern)) {
            return false;
        }
        Pattern this$excludePattern = this.getExcludePattern();
        Pattern other$excludePattern = other.getExcludePattern();
        return !(this$excludePattern == null ? other$excludePattern != null : !this$excludePattern.equals(other$excludePattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassNameRegExExclusionFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pattern $includePattern = this.getIncludePattern();
        result = result * 59 + ($includePattern == null ? 43 : $includePattern.hashCode());
        Pattern $excludePattern = this.getExcludePattern();
        result = result * 59 + ($excludePattern == null ? 43 : $excludePattern.hashCode());
        return result;
    }

    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public Pattern getExcludePattern() {
        return this.excludePattern;
    }
}

