/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.keystore;

import cz.xtf.docker.OpenShiftNode;
import cz.xtf.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class ProcessKeystoreGenerator {
    private static Path caDir;
    private static Path truststore;

    public static Path generateKeystore(String hostname) {
        return ProcessKeystoreGenerator.generateKeystore(hostname, hostname, true);
    }

    public static Path generateKeystore(String hostname, String keyAlias) {
        return ProcessKeystoreGenerator.generateKeystore(hostname, keyAlias, true);
    }

    public static Path generateKeystore(String hostname, String keyAlias, boolean importCa) {
        String keystore = hostname + ".keystore";
        if (caDir.resolve(keystore).toFile().exists()) {
            return caDir.resolve(keystore);
        }
        ProcessKeystoreGenerator.processCall(caDir, "keytool", "-genkeypair", "-keyalg", "RSA", "-noprompt", "-alias", keyAlias, "-dname", "CN=" + hostname + ", OU=TF, O=XTF, L=Brno, S=CZ, C=CZ", "-keystore", keystore, "-storepass", "password", "-keypass", "password");
        ProcessKeystoreGenerator.processCall(caDir, "keytool", "-keystore", keystore, "-certreq", "-alias", keyAlias, "--keyalg", "rsa", "-file", hostname + ".csr", "-storepass", "password");
        ProcessKeystoreGenerator.processCall(caDir, "openssl", "x509", "-req", "-CA", "ca-certificate.pem", "-CAkey", "ca-key.pem", "-in", hostname + ".csr", "-out", hostname + ".cer", "-days", "365", "-CAcreateserial", "-passin", "pass:password");
        if (importCa) {
            ProcessKeystoreGenerator.processCall(caDir, "keytool", "-import", "-noprompt", "-keystore", keystore, "-file", "ca-certificate.pem", "-alias", "xtf.ca", "-storepass", "password");
        }
        ProcessKeystoreGenerator.processCall(caDir, "keytool", "-import", "-keystore", keystore, "-file", hostname + ".cer", "-alias", keyAlias, "-storepass", "password");
        return caDir.resolve(keystore);
    }

    public static CertPaths generateCerts(String hostname) {
        String keystore = hostname + ".keystore";
        ProcessKeystoreGenerator.generateKeystore(hostname);
        ProcessKeystoreGenerator.processCall(caDir, "keytool", "-exportcert", "-rfc", "-keystore", keystore, "-alias", hostname, "-storepass", "password", "-file", keystore + ".pem");
        ProcessKeystoreGenerator.processCall(caDir, "keytool", "-importkeystore", "-noprompt", "-srckeystore", keystore, "-destkeystore", keystore + ".p12", "-deststoretype", "PKCS12", "-srcalias", hostname, "-deststorepass", "password", "-destkeypass", "password", "-srcstorepass", "password");
        ProcessKeystoreGenerator.processCall(caDir, "openssl", "pkcs12", "-in", keystore + ".p12", "-nodes", "-nocerts", "-out", keystore + ".keywithattrs.pem", "-passin", "pass:password");
        ProcessKeystoreGenerator.processCall(caDir, "openssl", "rsa", "-in", keystore + ".keywithattrs.pem", "-out", keystore + ".key.pem");
        return new CertPaths(caDir.resolve("ca-certificate.pem"), caDir.resolve("truststore"), caDir.resolve(keystore), caDir.resolve(keystore + ".key.pem"), caDir.resolve(keystore + ".pem"));
    }

    private static void processCall(Path cwd, String ... args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(cwd.toFile());
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        int result = -1;
        try {
            result = pb.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed executing " + String.join((CharSequence)" ", args));
        }
        if (result != 0) {
            throw new IllegalStateException("Failed executing " + String.join((CharSequence)" ", args));
        }
    }

    public static Path getCaDir() {
        return caDir;
    }

    public static Path getTruststore() {
        return truststore;
    }

    static {
        try {
            IOUtils.TMP_DIRECTORY.toFile().mkdirs();
            caDir = Files.createTempDirectory(IOUtils.TMP_DIRECTORY, "ca", new FileAttribute[0]);
            ProcessKeystoreGenerator.processCall(caDir, "openssl", "req", "-new", "-newkey", "rsa:4096", "-x509", "-keyout", "ca-key.pem", "-out", "ca-certificate.pem", "-days", "365", "-passout", "pass:password", "-subj", "/C=CZ/ST=CZ/L=Brno/O=QE/CN=xtf.ca");
            ProcessKeystoreGenerator.processCall(caDir, "keytool", "-import", "-noprompt", "-keystore", "truststore", "-file", "ca-certificate.pem", "-alias", "xtf.ca", "-storepass", "password");
            String routerCrt = OpenShiftNode.master().executeCommand("sudo cat /etc/origin/master/ca.crt");
            FileUtils.writeStringToFile((File)caDir.resolve("openshift-router.pem").toFile(), (String)routerCrt);
            ProcessKeystoreGenerator.processCall(caDir, "keytool", "-import", "-noprompt", "-keystore", "truststore", "-file", "openshift-router.pem", "-alias", "openshift-router", "-storepass", "password");
            truststore = caDir.resolve("truststore");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize ca", e);
        }
    }

    public static class CertPaths {
        public Path caPem;
        public Path truststore;
        public Path keystore;
        public Path keyPem;
        public Path certPem;

        public CertPaths(Path caPem, Path truststore, Path keystore, Path keyPem, Path certPem) {
            this.caPem = caPem;
            this.truststore = truststore;
            this.keystore = keystore;
            this.keyPem = keyPem;
            this.certPem = certPem;
        }
    }
}

