/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.manipulation;

import cz.xtf.TestConfiguration;
import cz.xtf.UsageRecorder;
import cz.xtf.http.HttpClient;
import cz.xtf.openshift.imagestream.ImageRegistry;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recorder {
    private static final Logger log = LoggerFactory.getLogger(Recorder.class);
    public static final String RUNTIME_PROPERTIES_FILE = "../used-test.properties";
    public static final String RUNTIME_IMAGES_FILE = "../used-images.properties";
    private static final String VERSION_FALLBACK = "N/A";

    private Recorder() {
    }

    public static void recordEnvironmentVersions() {
        TestConfiguration.get().storeConfiguration();
        String config = Recorder.retrieveConfig();
        Recorder.recordOpenShiftVersion(config);
        Recorder.recordKubeVersion(config);
    }

    public static void recordOpenShiftVersion() {
        String config = Recorder.retrieveConfig();
        Recorder.recordOpenShiftVersion(config);
    }

    public static void recordKubeVersion() {
        String config = Recorder.retrieveConfig();
        Recorder.recordKubeVersion(config);
    }

    public static void storeTestConfiguration() throws IOException {
        try (FileWriter writer = new FileWriter(RUNTIME_PROPERTIES_FILE);){
            TestConfiguration.get().storeConfigurationInFile(writer);
        }
    }

    public static void recordUsedImages(String ... imageNames) {
        Properties images = new Properties();
        log.info("action=record-images status=START imageNames={}", (Object)Arrays.toString(imageNames));
        try (FileWriter writer = new FileWriter(RUNTIME_IMAGES_FILE);){
            Stream.of(imageNames).forEach(name -> Recorder.addImage(images, name));
            images.store(writer, "Images used in test");
            log.info("action=record-images status=FINISH imageNames={}", (Object)Arrays.toString(imageNames));
        }
        catch (Exception e) {
            log.info("action=record-images status=ERROR imageNames={}", (Object)Arrays.toString(imageNames), (Object)e);
        }
    }

    private static void addImage(Properties images, String imageName) {
        try {
            log.debug("action=record-images status=PROCESS image={}", (Object)imageName);
            String image = (String)ImageRegistry.class.getDeclaredMethod(imageName, new Class[0]).invoke((Object)ImageRegistry.get(), new Object[0]);
            images.setProperty(imageName, image);
        }
        catch (ReflectiveOperationException e) {
            log.info("action=record-images status=ERROR image={}", (Object)imageName, (Object)e);
        }
    }

    private static String retrieveConfig() {
        log.info("action=retrieve-config.js status=START");
        try {
            String config = HttpClient.get(TestConfiguration.masterUrl() + "/console/config.js").response();
            log.debug("Retrieved config.js: {}", (Object)config);
            log.info("action=retrieve-config.js status=FINISH");
            return config;
        }
        catch (IOException e) {
            log.info("action=retrieve-config.js status=ERROR", (Throwable)e);
            return null;
        }
    }

    private static void recordOpenShiftVersion(String config) {
        UsageRecorder.recordOpenShiftVersion(config != null ? Recorder.getOpenShiftVersion(config) : VERSION_FALLBACK);
    }

    private static void recordKubeVersion(String config) {
        UsageRecorder.recordKubernetesVersion(config != null ? Recorder.getKubeVersion(config) : VERSION_FALLBACK);
    }

    private static String getOpenShiftVersion(String config) {
        Matcher oseMatcher = Pattern.compile("openshift: \"(v\\d+(.\\d+)+(-[a-zA-Z0-9]+)?)\"").matcher(config);
        return oseMatcher.find() ? oseMatcher.group(1) : VERSION_FALLBACK;
    }

    private static String getKubeVersion(String config) {
        Matcher kubeMatcher = Pattern.compile("kubernetes: \"(v\\d+(.\\d+)+(-[a-zA-Z0-9]+)?)\"").matcher(config);
        if (kubeMatcher.find()) {
            return kubeMatcher.group(1);
        }
        return Recorder.getKubeDefaultVersion();
    }

    private static String getKubeDefaultVersion() {
        log.info("action=retrieve-kube-version status=START");
        try {
            String version = HttpClient.get(TestConfiguration.masterUrl() + "/version").response();
            log.info("action=retrieve-kube-version status=FINISH");
            return ModelNode.fromJSONString((String)version).get("gitVersion").asString();
        }
        catch (IOException e) {
            log.info("action=retrieve-kube-version status=ERROR", (Throwable)e);
            return VERSION_FALLBACK;
        }
    }
}

