/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.model.TransportProtocol;
import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.tuple.Tuple;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EndpointBuilder
extends AbstractBuilder<Endpoints, EndpointBuilder> {
    private final List<String> endpointIPs = new ArrayList<String>();
    private final List<Tuple.Pair<Integer, TransportProtocol>> ports = new ArrayList<Tuple.Pair<Integer, TransportProtocol>>();

    public EndpointBuilder(String id) {
        this(null, id);
    }

    EndpointBuilder(ApplicationBuilder applicationBuilder, String id) {
        super(applicationBuilder, id);
    }

    public EndpointBuilder addIP(String ip) {
        this.endpointIPs.add(ip);
        return this;
    }

    public EndpointBuilder addPort(int port, TransportProtocol protocol) {
        this.ports.add(Tuple.pair(port, protocol));
        return this;
    }

    public EndpointBuilder addPort(int port) {
        return this.addPort(port, TransportProtocol.TCP);
    }

    @Override
    public Endpoints build() {
        if (this.endpointIPs.isEmpty() || this.ports.isEmpty()) {
            throw new IllegalStateException("IP list and port list must be non-empty");
        }
        EndpointSubsetBuilder subset = (EndpointSubsetBuilder)((EndpointSubsetBuilder)new EndpointSubsetBuilder().withAddresses(this.endpointIPs.stream().map(ip -> ((EndpointAddressBuilder)new EndpointAddressBuilder().withIp(ip)).build()).collect(Collectors.toList()))).withPorts(this.ports.stream().map(port -> ((EndpointPortBuilder)((EndpointPortBuilder)new EndpointPortBuilder().withPort((Integer)port.getFirst())).withProtocol(((TransportProtocol)((Object)((Object)port.getSecond()))).toString())).build()).collect(Collectors.toList()));
        return ((EndpointsBuilder)((EndpointsBuilder)new EndpointsBuilder().withMetadata(this.metadataBuilder().build())).withSubsets(new EndpointSubset[]{subset.build()})).build();
    }

    @Override
    protected EndpointBuilder getThis() {
        return this;
    }
}

