/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.model.TransportProtocol;
import cz.xtf.openshift.builder.AbstractBuilder;
import cz.xtf.openshift.builder.ApplicationBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceBuilder
extends AbstractBuilder<Service, ServiceBuilder> {
    private TransportProtocol protocol = TransportProtocol.TCP;
    private int port = 80;
    private int containerPort = 0;
    private SessionAffinity sessionAffinity = SessionAffinity.None;
    private Map<String, String> selectors = new HashMap<String, String>();
    private String clusterIP = null;
    private List<ServicePort> servicePorts = new ArrayList<ServicePort>();
    private boolean isNodePort = false;

    public ServiceBuilder(String id) {
        this(null, id);
    }

    ServiceBuilder(ApplicationBuilder applicationBuilder, String id) {
        super(applicationBuilder, id);
    }

    public ServiceBuilder useTCP() {
        this.protocol = TransportProtocol.TCP;
        return this;
    }

    public ServiceBuilder useUDP() {
        this.protocol = TransportProtocol.UDP;
        return this;
    }

    public ServiceBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public ServiceBuilder setContainerPort(int containerPort) {
        this.containerPort = containerPort;
        return this;
    }

    public ServiceBuilder clientIPStickiness() {
        this.sessionAffinity = SessionAffinity.ClientIP;
        return this;
    }

    public ServiceBuilder noStickiness() {
        this.sessionAffinity = SessionAffinity.None;
        return this;
    }

    public ServiceBuilder addContainerSelector(String key, String value) {
        this.selectors.put(key, value);
        return this;
    }

    public ServiceBuilder headless() {
        this.clusterIP = "None";
        return this;
    }

    public ServiceBuilder ports(List<ServicePort> servicePorts) {
        this.servicePorts.addAll(servicePorts);
        return this;
    }

    public ServiceBuilder ports(ServicePort ... servicePorts) {
        this.ports(Arrays.asList(servicePorts));
        return this;
    }

    public ServiceBuilder nodePort() {
        this.isNodePort = true;
        return this;
    }

    public ServiceBuilder withoutSelectors() {
        this.selectors.clear();
        return this;
    }

    @Override
    public Service build() {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        if (this.servicePorts.isEmpty()) {
            if (this.containerPort == 0) {
                throw new IllegalStateException("containerPort must be set for service");
            }
            spec.withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withProtocol(this.protocol.uppercase())).withPort(Integer.valueOf(this.port))).withNewTargetPort(Integer.valueOf(this.containerPort))).build()});
        } else {
            spec.withPorts(this.servicePorts);
        }
        spec.withSessionAffinity(this.sessionAffinity.toString());
        spec.withSelector(this.selectors);
        if (this.clusterIP != null) {
            spec.withClusterIP(this.clusterIP);
        }
        if (this.isNodePort) {
            spec.withType("NodePort");
        }
        return ((io.fabric8.kubernetes.api.model.ServiceBuilder)((io.fabric8.kubernetes.api.model.ServiceBuilder)new io.fabric8.kubernetes.api.model.ServiceBuilder().withMetadata(this.metadataBuilder().build())).withSpec(spec.build())).build();
    }

    @Override
    protected ServiceBuilder getThis() {
        return this;
    }

    private static enum SessionAffinity {
        None,
        ClientIP;

    }
}

