/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.sso.api;

import cz.xtf.sso.api.ProtocolType;
import cz.xtf.sso.api.Provider;
import cz.xtf.sso.api.SsoApi;
import cz.xtf.sso.api.entity.User;
import cz.xtf.sso.util.DriverUtil;
import cz.xtf.webdriver.WebDriverService;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.Select;

public class SsoWebUIApi
implements SsoApi {
    private final String authUrl;
    private final String realm;
    private final WebDriver driver;

    public static SsoWebUIApi get(String authUrl, String realm) {
        return new SsoWebUIApi(authUrl, realm);
    }

    private SsoWebUIApi(String authUrl, String realm) {
        this.authUrl = authUrl;
        this.realm = realm;
        this.driver = WebDriverService.get().start();
        this.login(this.driver);
    }

    @Override
    public String createUser(String username, String password, String firstname, String lastname, String email, List<String> rolenames) {
        try {
            String createUserPage = this.authUrl + "/admin/master/console/#/create/user/" + this.realm + "/";
            this.driver.navigate().to(createUserPage);
            DriverUtil.waitFor(this.driver, By.id((String)"username"));
            this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{username});
            DriverUtil.waitFor(this.driver, By.cssSelector((String)".btn-primary"));
            this.driver.findElement(By.cssSelector((String)".btn-primary")).click();
            Thread.sleep(3000L);
            DriverUtil.waitFor(this.driver, By.id((String)"id"));
            String id = this.driver.findElement(By.id((String)"id")).getAttribute("value");
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/users/" + id + "/user-credentials");
            DriverUtil.waitFor(this.driver, By.id((String)"password"), By.id((String)"confirmPassword"));
            this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{password});
            this.driver.findElement(By.id((String)"confirmPassword")).sendKeys(new CharSequence[]{password});
            this.driver.findElement(By.cssSelector((String)".onoffswitch-active")).click();
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Reset Password')]")).click();
            DriverUtil.waitFor(this.driver, By.xpath((String)"//button[contains(text(),'Change password')]"));
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Change password')]")).click();
            if (rolenames != null && rolenames.size() > 0) {
                for (String role : rolenames) {
                    this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/users/" + id + "/role-mappings");
                    DriverUtil.waitFor(this.driver, By.id((String)"available"));
                    List list = this.driver.findElement(By.id((String)"available")).findElements(By.tagName((String)"option")).stream().map(element -> element.getText()).collect(Collectors.toList());
                    new Actions(this.driver).moveToElement(this.driver.findElement(By.xpath((String)"//select[@id='available']"))).click().perform();
                    for (int i = 0; i < list.size() + 1; ++i) {
                        new Actions(this.driver).sendKeys(new CharSequence[]{Keys.ARROW_UP}).perform();
                    }
                    for (String text : list) {
                        if (role.equals(text)) {
                            this.driver.findElement(By.xpath((String)"//button[@ng-click='addRealmRole()']")).click();
                            break;
                        }
                        new Actions(this.driver).sendKeys(new CharSequence[]{Keys.ARROW_DOWN}).perform();
                    }
                    Thread.sleep(3000L);
                }
            }
            return id;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public void createRole(String rolename) {
        try {
            String createRolePage = this.authUrl + "/admin/master/console/#/create/role/" + this.realm + "/";
            this.driver.navigate().to(createRolePage);
            DriverUtil.waitFor(this.driver, By.id((String)"name"));
            this.driver.findElement(By.id((String)"name")).sendKeys(new CharSequence[]{rolename});
            DriverUtil.waitFor(this.driver, By.cssSelector((String)".btn-primary"));
            this.driver.findElement(By.cssSelector((String)".btn-primary")).click();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to create role", e);
        }
    }

    @Override
    public String createOidcBearerClient(String clientName) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/create/client/" + this.realm + "/");
            DriverUtil.waitFor(this.driver, By.id((String)"clientId"));
            this.driver.findElement(By.id((String)"clientId")).sendKeys(new CharSequence[]{clientName});
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            DriverUtil.waitFor(this.driver, By.id((String)"accessType"));
            Select accessTypeSelect = new Select(this.driver.findElement(By.id((String)"accessType")));
            accessTypeSelect.selectByVisibleText(OpenIdAccessType.BEARER_ONLY.getLabel());
            String clientId = this.driver.getCurrentUrl();
            int lastSlash = clientId.lastIndexOf("/");
            clientId = clientId.substring(lastSlash + 1);
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            return clientId;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public String createOicdConfidentialClient(String clientName, String rootUrl, List<String> redirectUri, String baseUrl, String adminUrl) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/create/client/" + this.realm + "/");
            DriverUtil.waitFor(this.driver, By.id((String)"clientId"), By.id((String)"rootUrl"));
            this.driver.findElement(By.id((String)"clientId")).sendKeys(new CharSequence[]{clientName});
            this.driver.findElement(By.id((String)"rootUrl")).sendKeys(new CharSequence[]{rootUrl});
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            DriverUtil.waitFor(this.driver, By.id((String)"accessType"));
            Select accessTypeSelect = new Select(this.driver.findElement(By.id((String)"accessType")));
            accessTypeSelect.selectByVisibleText(OpenIdAccessType.CONFIDENTIAL.getLabel());
            DriverUtil.waitFor(this.driver, By.id((String)"newRedirectUri"), By.id((String)"rootUrl"));
            this.driver.findElement(By.id((String)"newRedirectUri")).sendKeys(new CharSequence[]{redirectUri.get(0)});
            this.driver.findElement(By.id((String)"baseUrl")).sendKeys(new CharSequence[]{baseUrl});
            this.driver.findElement(By.id((String)"adminUrl")).sendKeys(new CharSequence[]{adminUrl});
            String clientId = this.driver.getCurrentUrl();
            int lastSlash = clientId.lastIndexOf("/");
            clientId = clientId.substring(lastSlash + 1);
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            return clientId;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public String createInsecureSamlClient(String clientName, String masterSamlUrl, String baseUrl, List<String> redirectUris) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/create/client/" + this.realm + "/");
            DriverUtil.waitFor(this.driver, By.id((String)"clientId"));
            this.driver.findElement(By.id((String)"clientId")).sendKeys(new CharSequence[]{clientName});
            Select accessTypeSelect = new Select(this.driver.findElement(By.id((String)"protocol")));
            accessTypeSelect.selectByVisibleText(ProtocolType.SAML.getLabel());
            this.driver.findElement(By.id((String)"masterSamlUrl")).sendKeys(new CharSequence[]{masterSamlUrl});
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            DriverUtil.waitFor(this.driver, By.id((String)"baseUrl"), By.id((String)"newRedirectUri"));
            this.driver.findElement(By.xpath((String)"//label[@for='samlServerSignature']/span/span[contains(@class, 'onoffswitch-active')]")).click();
            this.driver.findElement(By.xpath((String)"//label[@for='samlClientSignature']/span/span[contains(@class, 'onoffswitch-active')]")).click();
            this.driver.findElement(By.id((String)"baseUrl")).sendKeys(new CharSequence[]{baseUrl});
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            for (String redirectUri : redirectUris) {
                DriverUtil.waitFor(this.driver, By.id((String)"newRedirectUri"));
                this.driver.findElement(By.id((String)"newRedirectUri")).sendKeys(new CharSequence[]{redirectUri});
                this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            }
            String clientUuid = this.driver.getCurrentUrl();
            int lastSlash = clientUuid.lastIndexOf("/");
            return clientUuid.substring(lastSlash + 1);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to create saml client");
        }
    }

    @Override
    public String createOidcPublicClient(String clientName, String rootUrl, List<String> redirectUris, List<String> webOrigins) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/create/client/" + this.realm + "/");
            DriverUtil.waitFor(this.driver, By.id((String)"clientId"), By.id((String)"rootUrl"));
            this.driver.findElement(By.id((String)"clientId")).sendKeys(new CharSequence[]{clientName});
            this.driver.findElement(By.id((String)"rootUrl")).sendKeys(new CharSequence[]{rootUrl});
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            DriverUtil.waitFor(this.driver, By.id((String)"accessType"));
            Select accessTypeSelect = new Select(this.driver.findElement(By.id((String)"accessType")));
            accessTypeSelect.selectByVisibleText(OpenIdAccessType.PUBLIC.getLabel());
            DriverUtil.waitFor(this.driver, By.id((String)"newRedirectUri"), By.id((String)"newWebOrigin"), By.id((String)"rootUrl"));
            this.driver.findElement(By.id((String)"newRedirectUri")).sendKeys(new CharSequence[]{redirectUris.get(0)});
            if (webOrigins != null) {
                this.driver.findElement(By.id((String)"newWebOrigin")).sendKeys(new CharSequence[]{webOrigins.get(0)});
            }
            String clientId = this.driver.getCurrentUrl();
            int lastSlash = clientId.lastIndexOf("/");
            clientId = clientId.substring(lastSlash + 1);
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
            return clientId;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public void addRealmRolesToUser(String username, List<String> rolenames) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void addBultinMappersToSamlClient(String clientId) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/clients/" + clientId + "/add-mappers");
            DriverUtil.waitFor(this.driver, By.id((String)"saml-user-property-mapper"), By.xpath((String)"//button[contains(text(),'Add selected')]"));
            this.driver.findElement(By.xpath((String)"//tbody/tr/td[position()=1 and contains(text(), 'givenName')]/../td[position()=4]/input")).click();
            this.driver.findElement(By.xpath((String)"//tbody/tr/td[position()=1 and contains(text(), 'surname')]/../td[position()=4]/input")).click();
            this.driver.findElement(By.xpath((String)"//tbody/tr/td[position()=1 and contains(text(), 'email')]/../td[position()=4]/input")).click();
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Add selected')]")).click();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public String getUserId(String username) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/users");
            DriverUtil.waitFor(this.driver, By.xpath((String)"//button[contains(text(),'View all users')]"));
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'View all users')]")).click();
            DriverUtil.waitFor(this.driver, By.xpath((String)("//tbody/tr/td[position()=1]/a[text()='" + username + "']")));
            String href = this.driver.findElement(By.xpath((String)("//tbody/tr/td[position()=1]/a[text()='" + username + "']"))).getAttribute("href");
            int lastSlash = href.lastIndexOf("/");
            return href.substring(lastSlash + 1);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public String getClientId(String clientName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getRealmId() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getRealmPublicKey() {
        try {
            String roleKeysPage = this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/keys-settings";
            this.driver.navigate().to(roleKeysPage);
            DriverUtil.waitFor(this.driver, By.id((String)"publicKey"));
            return this.driver.findElement(By.id((String)"publicKey")).getText();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to get public key", e);
        }
    }

    @Override
    public String getOicdInstallationXmlFile(String clientId) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/clients/" + clientId + "/installation/");
            DriverUtil.waitFor(this.driver, By.id((String)"configFormats"));
            Select configFormatSelect = new Select(this.driver.findElement(By.id((String)"configFormats")));
            configFormatSelect.selectByVisibleText(Provider.OIDC_JBOSS_XML_SUBSYSTEM.getWebUiLabel());
            return this.driver.findElement(By.xpath((String)"//textarea[contains(text(),'secure-deployment')]")).getText();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public String getSamlInstallationXmlFile(String clientId) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/clients/" + clientId + "/installation/");
            DriverUtil.waitFor(this.driver, By.id((String)"configFormats"));
            Select configFormatSelect = new Select(this.driver.findElement(By.id((String)"configFormats")));
            configFormatSelect.selectByVisibleText(Provider.SAML_JBOSS_XML_SUBSYSTEM.getWebUiLabel());
            return this.driver.findElement(By.xpath((String)"//textarea[contains(text(),'<SingleSignOnService')]")).getText();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to get saml installation file");
        }
    }

    @Override
    public String getJsonInstallationFile(String clientId) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/clients/" + clientId + "/installation/");
            DriverUtil.waitFor(this.driver, By.id((String)"configFormats"));
            Select configFormatSelect = new Select(this.driver.findElement(By.id((String)"configFormats")));
            configFormatSelect.selectByVisibleText(Provider.OIDC_KEYCLOAK_JSON.getWebUiLabel());
            return this.driver.findElement(By.xpath((String)"//textarea[contains(text(),'auth-server-url')]")).getText();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public void updateUserDetails(User user) {
        try {
            String userDetailPage = this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/users/" + user.id;
            this.driver.navigate().to(userDetailPage);
            DriverUtil.waitFor(this.driver, By.id((String)"email"), By.id((String)"firstName"), By.id((String)"lastName"));
            this.driver.findElement(By.id((String)"email")).clear();
            this.driver.findElement(By.id((String)"email")).sendKeys(new CharSequence[]{user.email});
            this.driver.findElement(By.id((String)"firstName")).clear();
            this.driver.findElement(By.id((String)"firstName")).sendKeys(new CharSequence[]{user.firstName});
            this.driver.findElement(By.id((String)"lastName")).clear();
            this.driver.findElement(By.id((String)"lastName")).sendKeys(new CharSequence[]{user.lastName});
            this.driver.findElements(By.xpath((String)"//button[@class='ng-binding btn btn-primary']")).stream().filter(element -> element.isEnabled() && element.isDisplayed()).findFirst().get().click();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to ...", e);
        }
    }

    @Override
    public void deleteUser(String userId) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void forceNameIdFormat(String clientId) {
        try {
            this.driver.navigate().to(this.authUrl + "/admin/master/console/#/realms/" + this.realm + "/clients/" + clientId);
            By xpath = By.xpath((String)"//label[@for='samlForceNameIdFormat']/span/span[contains(@class, 'onoffswitch-active')]");
            DriverUtil.waitFor(this.driver, xpath, By.xpath((String)"//button[contains(text(),'Save')]"));
            this.driver.findElement(xpath).click();
            this.driver.findElement(By.xpath((String)"//button[contains(text(),'Save')]")).click();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Failed to force name id format!", e);
        }
    }

    @Override
    public void updateClientRedirectUri(String clientId, List<String> redirectUris) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void close() {
        this.driver.close();
    }

    private void login(WebDriver driver) {
        try {
            driver.navigate().to(this.authUrl + "/admin");
            DriverUtil.login(driver, "admin", "admin");
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("Didn't manage to login!", e);
        }
    }

    public static enum OpenIdAccessType {
        CONFIDENTIAL("confidential"),
        PUBLIC("public"),
        BEARER_ONLY("bearer-only");

        private String label;

        private OpenIdAccessType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

