/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.build;

import cz.xtf.TestConfiguration;
import cz.xtf.build.BuildDefinition;
import cz.xtf.build.BuildProcess;
import cz.xtf.build.BuildProcessFactory;
import cz.xtf.openshift.OpenshiftUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildManagerV2 {
    private static final Logger log = LoggerFactory.getLogger(BuildManagerV2.class);
    private final Map<BuildDefinition, BuildProcess> builds = new HashMap<BuildDefinition, BuildProcess>();

    public static BuildManagerV2 get() {
        return BuildManagerHolder.MANAGER;
    }

    private BuildManagerV2() {
        OpenshiftUtil openshift = OpenshiftUtil.getInstance();
        openshift.createProject(TestConfiguration.buildNamespace(), false);
        openshift.addRoleToGroup(TestConfiguration.buildNamespace(), "system:image-puller", "system:authenticated");
        openshift.createHardResourceQuota(TestConfiguration.buildNamespace(), "max-running-builds", "pods", "5");
    }

    public void deployBuild(BuildDefinition definition) {
        this.deployBuild(true, definition);
    }

    public void deployBuild(boolean waitForCompletion, BuildDefinition definition) {
        BuildProcess process = this.builds.getOrDefault(definition, BuildProcessFactory.getProcess(definition));
        this.builds.putIfAbsent(definition, process);
        BuildProcess.BuildStatus status = process.getBuildStatus();
        if (TestConfiguration.forceRebuild() || status == BuildProcess.BuildStatus.NOT_DEPLOYED || status == BuildProcess.BuildStatus.OLD_IMAGE || status == BuildProcess.BuildStatus.GIT_REPO_GONE || status == BuildProcess.BuildStatus.ERROR || status == BuildProcess.BuildStatus.FAILED) {
            process.deleteBuild();
            process.deployBuild();
            log.info("Building {}, reason: {}, force rebuild: {}", new Object[]{process.getBuildName(), status, TestConfiguration.forceRebuild()});
        } else if (status == BuildProcess.BuildStatus.SOURCE_CHANGE) {
            process.updateBuild();
            log.info("Building {}, reason: {}", new Object[]{process.getBuildName(), status, TestConfiguration.forceRebuild()});
        } else {
            log.info("Build {} present, status: {}", new Object[]{process.getBuildName(), status, TestConfiguration.forceRebuild()});
        }
        if (waitForCompletion) {
            process.waitForCompletion();
        }
    }

    public void deployBuilds(Collection<? extends BuildDefinition> definitions) {
        definitions.forEach(buildDef -> this.deployBuild(false, (BuildDefinition)buildDef));
    }

    public void waitForBuildCompletion(BuildDefinition definition) {
        this.builds.get(definition).waitForCompletion();
    }

    public void waitForBuildCompletion(BuildDefinition definition, long timeout) {
        this.builds.get(definition).waitForCompletion(timeout);
    }

    public void deleteBuild(BuildDefinition definition) {
        this.builds.get(definition).deleteBuild();
    }

    public BuildProcess.BuildStatus getBuildStatus(BuildDefinition definition) {
        return this.builds.get(definition).getBuildStatus();
    }

    private static class BuildManagerHolder {
        static final BuildManagerV2 MANAGER = new BuildManagerV2();

        private BuildManagerHolder() {
        }
    }
}

